/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.internal.Assert;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gef.ui.parts.GraphicalRootEditPart;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GraphicalViewerImpl
extends AbstractEditPartViewer
implements GraphicalViewer {
    private LightweightSystem system;
    IFigure rootFigure;
    private DomainEventDispatcher eventDispatcher;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GraphicalViewerImpl() {
        this.createDefaultRoot();
    }

    public Control createControl(Composite composite) {
        this.setControl((Control)new Canvas(composite, 0));
        return this.getControl();
    }

    protected void createDefaultRoot() {
        this.setRootEditPart(new GraphicalRootEditPart());
    }

    protected void expose(EditPart part) {
        AccessibleEditPart acc;
        if (part == null) {
            return;
        }
        EditPart current = part.getParent();
        while (current != null) {
            if (current instanceof IAdaptable) {
                ExposeHelper helper;
                IAdaptable adaptable = current;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.gef.ExposeHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((helper = (ExposeHelper)adaptable.getAdapter((Class)clazz)) != null) {
                    helper.exposeDescendant(part);
                }
            }
            current = current.getParent();
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.AccessibleEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acc = (AccessibleEditPart)((Object)part.getAdapter(clazz))) != null) {
            this.getControl().getAccessible().setFocus(acc.getAccessibleID());
        }
    }

    public Handle findHandleAt(Point p) {
        LayerManager layermanager = (LayerManager)this.getEditPartRegistry().get(LayerManager.ID);
        if (layermanager == null) {
            return null;
        }
        ArrayList<IFigure> list = new ArrayList<IFigure>(3);
        list.add(layermanager.getLayer("Primary Layer"));
        list.add(layermanager.getLayer("Connection Layer"));
        list.add(layermanager.getLayer("Feedback Layer"));
        IFigure handle = this.getLightweightSystem().getRootFigure().findFigureAtExcluding(p.x, p.y, list);
        if (handle instanceof Handle) {
            return (Handle)handle;
        }
        return null;
    }

    public EditPart findObjectAt(Point pt) {
        return this.findObjectAtExcluding(pt, Collections.EMPTY_SET);
    }

    public EditPart findObjectAtExcluding(Point pt, Collection exclude) {
        ArrayList c = new ArrayList(this.getInactiveLayers());
        c.addAll(exclude);
        IFigure figure = this.getLightweightSystem().getRootFigure().findFigureAtExcluding(pt.x, pt.y, c);
        EditPart part = (EditPart)this.getVisualPartMap().get(figure);
        while (figure != null && part == null) {
            figure = figure.getParent();
            part = (EditPart)this.getVisualPartMap().get(figure);
        }
        if (part == null) {
            return this.getContents();
        }
        return part;
    }

    public void flush() {
        this.getLightweightSystem().getUpdateManager().performUpdate();
    }

    protected DomainEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected Collection getInactiveLayers() {
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        LayerManager layers = this.getLayerManager();
        list.add(layers.getLayer("Handle Layer"));
        list.add(layers.getLayer("Feedback Layer"));
        return list;
    }

    protected LayerManager getLayerManager() {
        return (LayerManager)this.getEditPartRegistry().get(LayerManager.ID);
    }

    protected LightweightSystem getLightweightSystem() {
        if (this.system == null) {
            this.system = new LightweightSystem();
        }
        return this.system;
    }

    protected IFigure getRootFigure() {
        return this.rootFigure;
    }

    protected void hookDropTarget() {
        super.hookDropTarget();
        this.getDropTarget().addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                GraphicalViewerImpl.this.flush();
            }

            public void dragLeave(DropTargetEvent event) {
                GraphicalViewerImpl.this.flush();
            }

            public void dragOver(DropTargetEvent event) {
                GraphicalViewerImpl.this.flush();
            }
        });
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.flush();
        super.menuAboutToShow(menu);
    }

    protected void hookControl() {
        super.hookControl();
        this.getLightweightSystem().setControl((Canvas)this.getControl());
    }

    public void registerAccessibleEditPart(AccessibleEditPart acc) {
        Assert.isNotNull((Object)acc);
        this.getEventDispatcher().putAccessible(acc);
    }

    public void setCursor(Cursor newCursor) {
        if (this.getEventDispatcher() != null) {
            this.getEventDispatcher().setOverrideCursor(newCursor);
        }
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.eventDispatcher = new DomainEventDispatcher(domain, this);
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
    }

    void setLightweightSystem(LightweightSystem lws) {
        if (this.getControl() != null) {
            throw new RuntimeException("The LightweightSystem cannot be changed once the Control has been set");
        }
        this.system = lws;
        if (this.eventDispatcher != null) {
            this.system.setEventDispatcher((EventDispatcher)this.eventDispatcher);
        }
        if (this.rootFigure != null) {
            this.system.setContents(this.rootFigure);
        }
    }

    public void setRootEditPart(RootEditPart editpart) {
        super.setRootEditPart(editpart);
        this.setRootFigure(((GraphicalEditPart)((Object)editpart)).getFigure());
    }

    protected void setRootFigure(IFigure figure) {
        this.rootFigure = figure;
        this.getLightweightSystem().setContents(this.rootFigure);
    }

    public void setRouteEventsToEditor(boolean value) {
        this.getEventDispatcher().setRouteEventsToEditor(value);
    }

    public void unregisterAccessibleEditPart(AccessibleEditPart acc) {
        Assert.isNotNull((Object)acc);
        this.getEventDispatcher().removeAccessible(acc);
    }
}

