/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerImpl;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.Splitter;
import org.eclipse.swt.widgets.Composite;

public abstract class GraphicalEditorWithPalette
extends GraphicalEditor {
    private PaletteViewer paletteViewer;

    protected void configurePaletteViewer() {
        this.getPaletteViewer().getControl().setBackground(ColorConstants.buttonLightest);
    }

    private void createPaletteViewer(Composite parent) {
        PaletteViewerImpl viewer = new PaletteViewerImpl();
        viewer.createControl(parent);
        this.setPaletteViewer(viewer);
        this.configurePaletteViewer();
        this.hookPaletteViewer();
        this.initializePaletteViewer();
    }

    public void createPartControl(Composite parent) {
        Splitter splitter = new Splitter(parent, 256);
        this.createPaletteViewer(splitter);
        this.createGraphicalViewer(splitter);
        splitter.setWeights(new int[]{1, 6});
    }

    public void dispose() {
        this.getPaletteViewer().dispose();
        super.dispose();
    }

    protected abstract PaletteRoot getPaletteRoot();

    protected PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    protected void hookPaletteViewer() {
        this.getEditDomain().setPaletteViewer(this.paletteViewer);
    }

    protected void initializePaletteViewer() {
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    protected void setPaletteViewer(PaletteViewer paletteViewer) {
        this.paletteViewer = paletteViewer;
    }
}

