/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.DelegatingDragAdapter;
import org.eclipse.gef.dnd.DelegatingDropAdapter;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.internal.Assert;
import org.eclipse.gef.ui.parts.ContextMenuProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class AbstractEditPartViewer
implements EditPartViewer,
IMenuListener {
    protected final List selection = new ArrayList();
    protected final List constantSelection = Collections.unmodifiableList(this.selection);
    protected List selectionListeners = new ArrayList(1);
    private EditPartFactory factory;
    private Map mapIDToEditPart = new HashMap();
    private Map mapVisualToEditPart = new HashMap();
    private Control control;
    private EditDomain domain;
    private RootEditPart rootEditPart;
    private EditPart focusPart;
    private ContextMenuProvider contextMenuProvider;
    private DelegatingDragAdapter dragAdapter = new DelegatingDragAdapter();
    private DragSource dragSource;
    private DelegatingDropAdapter dropAdapter = new DelegatingDropAdapter();
    private DropTarget dropTarget;
    private KeyHandler keyHandler;

    public AbstractEditPartViewer() {
        this.init();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void addDragSourceListener(TransferDragSourceListener listener) {
        this.getDelegatingDragAdapter().addDragSourceListener(listener);
        this.refreshDragSourceAdapter();
    }

    public void addDropTargetListener(TransferDropTargetListener listener) {
        this.getDelegatingDropAdapter().addDropTargetListener(listener);
        this.refreshDropTargetAdapter();
    }

    public void appendSelection(EditPart editpart) {
        List list;
        if (editpart != this.focusPart) {
            this.setFocus(null);
        }
        if (!(list = this.primGetSelectedEditParts()).isEmpty()) {
            EditPart primary = (EditPart)list.get(list.size() - 1);
            primary.setSelected(1);
        }
        if (list.contains(editpart)) {
            list.remove(editpart);
        }
        list.add(editpart);
        editpart.setSelected(2);
        this.fireSelectionChanged();
        this.expose(editpart);
    }

    public abstract Control createControl(Composite var1);

    public void deselect(EditPart editpart) {
        editpart.setSelected(0);
        List selection = this.primGetSelectedEditParts();
        selection.remove(editpart);
        if (!selection.isEmpty()) {
            EditPart primary = (EditPart)selection.get(selection.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        List list = this.primGetSelectedEditParts();
        this.setFocus(null);
        int i = 0;
        while (i < list.size()) {
            EditPart part = (EditPart)list.get(i);
            part.setSelected(0);
            ++i;
        }
        list.clear();
        this.fireSelectionChanged();
    }

    public void dispose() {
        this.primDeselectAll();
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().dispose();
        }
        this.setControl(null);
    }

    protected void expose(EditPart part) {
    }

    protected void fireSelectionChanged() {
        Iterator iter = this.selectionListeners.iterator();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        while (iter.hasNext()) {
            ISelectionChangedListener l = (ISelectionChangedListener)iter.next();
            l.selectionChanged(event);
        }
    }

    public void flush() {
    }

    protected ContextMenuProvider getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public EditPart getContents() {
        return this.getRootEditPart().getContents();
    }

    public Control getControl() {
        return this.control;
    }

    protected DelegatingDragAdapter getDelegatingDragAdapter() {
        return this.dragAdapter;
    }

    protected DelegatingDropAdapter getDelegatingDropAdapter() {
        return this.dropAdapter;
    }

    protected DragSource getDragSource() {
        return this.dragSource;
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public EditDomain getEditDomain() {
        return this.domain;
    }

    public EditPartFactory getEditPartFactory() {
        return this.factory;
    }

    public Map getEditPartRegistry() {
        return this.mapIDToEditPart;
    }

    public EditPart getFocusEditPart() {
        if (this.focusPart != null) {
            return this.focusPart;
        }
        if (this.getSelectedEditParts().isEmpty() && this.getContents() != null) {
            return this.getContents();
        }
        return (EditPart)this.getSelectedEditParts().get(0);
    }

    public KeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public RootEditPart getRootEditPart() {
        return this.rootEditPart;
    }

    public List getSelectedEditParts() {
        return this.constantSelection;
    }

    public ISelection getSelection() {
        if (this.getSelectedEditParts().isEmpty() && this.getContents() != null) {
            return new StructuredSelection((Object)this.getContents());
        }
        return new StructuredSelection(this.getSelectedEditParts());
    }

    public Map getVisualPartMap() {
        return this.mapVisualToEditPart;
    }

    protected void hookControl() {
        if (this.getControl() == null) {
            return;
        }
        MenuManager manager = new MenuManager();
        manager.addMenuListener((IMenuListener)this);
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu(this.control);
        this.control.setMenu(menu);
        if (this.getRootEditPart() != null) {
            this.getRootEditPart().activate();
        }
        this.refreshDragSourceAdapter();
        this.refreshDropTargetAdapter();
    }

    protected void hookDragSource() {
        this.dragSource.addDragListener((DragSourceListener)this.getDelegatingDragAdapter());
    }

    protected void hookDropTarget() {
        this.getDropTarget().addDropListener((DropTargetListener)this.getDelegatingDropAdapter());
    }

    protected void init() {
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (this.getContextMenuProvider() != null) {
            this.getContextMenuProvider().buildContextMenu(menu, this);
        }
    }

    private void primDeselectAll() {
        List list = this.primGetSelectedEditParts();
        int i = 0;
        while (i < list.size()) {
            EditPart part = (EditPart)list.get(i);
            part.setSelected(0);
            ++i;
        }
        list.clear();
    }

    protected List primGetSelectedEditParts() {
        return this.selection;
    }

    protected void refreshDragSourceAdapter() {
        if (this.getControl() == null) {
            return;
        }
        if (this.getDelegatingDragAdapter().isEmpty()) {
            this.setDragSource(null);
        } else if (this.getDragSource() == null) {
            this.setDragSource(new DragSource(this.getControl(), 7));
        }
    }

    protected void refreshDropTargetAdapter() {
        if (this.getControl() == null) {
            return;
        }
        if (this.getDelegatingDropAdapter().isEmpty()) {
            this.setDropTarget(null);
        } else {
            if (this.getDropTarget() == null) {
                this.setDropTarget(new DropTarget(this.getControl(), 7));
            }
            this.getDropTarget().setTransfer(this.getDelegatingDropAdapter().getTransferTypes());
        }
    }

    public void registerAccessibleEditPart(AccessibleEditPart acc) {
    }

    public void removeDragSourceListener(TransferDragSourceListener listener) {
        this.getDelegatingDragAdapter().removeDragSourceListener(listener);
        if (this.getDelegatingDragAdapter().isEmpty()) {
            this.refreshDragSourceAdapter();
        }
    }

    public void removeDropTargetListener(TransferDropTargetListener listener) {
        this.getDelegatingDropAdapter().removeDropTargetListener(listener);
        if (this.getDelegatingDropAdapter().isEmpty()) {
            this.refreshDropTargetAdapter();
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.selectionListeners.remove(l);
    }

    public void select(EditPart editpart) {
        this.primDeselectAll();
        this.appendSelection(editpart);
    }

    public void setContextMenuProvider(ContextMenuProvider provider) {
        this.contextMenuProvider = provider;
    }

    public void setContents(EditPart editpart) {
        this.getRootEditPart().setContents(editpart);
    }

    public void setControl(Control control) {
        if (this.control != null) {
            this.unhookControl();
        }
        this.control = control;
        if (control != null) {
            this.hookControl();
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.getControl().setCursor(cursor);
    }

    private void setDragSource(DragSource source) {
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        this.dragSource = source;
        if (this.dragSource != null) {
            this.hookDragSource();
        }
    }

    public void setDropTarget(DropTarget target) {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dropTarget = target;
        if (this.dropTarget != null) {
            this.hookDropTarget();
        }
    }

    public void setEditDomain(EditDomain editdomain) {
        this.domain = editdomain;
    }

    public void setEditPartFactory(EditPartFactory factory) {
        this.factory = factory;
    }

    public void setFocus(EditPart part) {
        if (this.focusPart == part) {
            return;
        }
        if (this.focusPart != null) {
            this.focusPart.setFocus(false);
        }
        this.focusPart = part;
        if (this.focusPart != null) {
            this.focusPart.setFocus(true);
            this.expose(this.focusPart);
        }
    }

    public void setContents(Object contents) {
        Assert.isTrue(this.getEditPartFactory() != null, "An EditPartFactory is required to call setContents(Object)");
        this.setContents(this.getEditPartFactory().createEditPart(null, contents));
    }

    public void setKeyHandler(KeyHandler handler) {
        this.keyHandler = handler;
    }

    public void setRootEditPart(RootEditPart editpart) {
        this.rootEditPart = editpart;
        this.rootEditPart.setViewer(this);
        if (this.getControl() != null) {
            this.rootEditPart.activate();
        }
    }

    public void setRouteEventsToEditor(boolean value) {
    }

    public void setSelection(ISelection newSelection) {
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        List editparts = ((IStructuredSelection)newSelection).toList();
        List selection = this.primGetSelectedEditParts();
        this.setFocus(null);
        int i = 0;
        while (i < selection.size()) {
            ((EditPart)selection.get(i)).setSelected(0);
            ++i;
        }
        selection.clear();
        i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            selection.add(part);
            if (i == editparts.size() - 1) {
                part.setSelected(2);
                this.expose(part);
            } else {
                part.setSelected(1);
            }
            ++i;
        }
        this.fireSelectionChanged();
    }

    protected void unhookControl() {
        if (this.getControl() == null) {
            return;
        }
        if (this.getRootEditPart() != null) {
            this.getRootEditPart().deactivate();
        }
    }

    public void unregisterAccessibleEditPart(AccessibleEditPart acc) {
    }

    public abstract EditPart findObjectAt(Point var1);

    public abstract EditPart findObjectAtExcluding(Point var1, Collection var2);
}

