/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ButtonGroup;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteEvent;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteToolEntry;
import org.eclipse.gef.ui.palette.EntryEditPart;
import org.eclipse.gef.ui.palette.PaletteEditPartFactory;
import org.eclipse.gef.ui.palette.PaletteRootEditPart;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.gef.ui.parts.PaletteViewerKeyHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;

public class PaletteViewerImpl
extends GraphicalViewerImpl
implements PaletteViewer {
    List paletteListeners = new ArrayList();
    ButtonGroup buttonGroup = null;
    PaletteEntry selectedEntry = null;
    PaletteRoot paletteRoot = null;

    public void addPaletteListener(PaletteListener paletteListener) {
        if (this.paletteListeners != null) {
            this.paletteListeners.add(paletteListener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    protected void createDefaultRoot() {
        this.setRootEditPart(new PaletteRootEditPart());
    }

    protected void firePaletteSelectionChanged() {
        if (this.paletteListeners == null) {
            return;
        }
        PaletteEvent event = new PaletteEvent(this, this.selectedEntry);
        int listener = 0;
        while (listener < this.paletteListeners.size()) {
            ((PaletteListener)this.paletteListeners.get(listener)).entrySelected(event);
            ++listener;
        }
    }

    public ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    public EditPartFactory getEditPartFactory() {
        if (super.getEditPartFactory() == null) {
            this.setEditPartFactory(new PaletteEditPartFactory());
        }
        return super.getEditPartFactory();
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    protected void init() {
        this.setEditDomain(new DefaultEditDomain(null));
        this.setKeyHandler(new PaletteViewerKeyHandler(this));
    }

    public PaletteToolEntry getSelectedEntry() {
        return (PaletteToolEntry)this.selectedEntry;
    }

    public void removePaletteListener(PaletteListener paletteListener) {
        this.paletteListeners.remove(paletteListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setPaletteRoot(PaletteRoot root) {
        this.paletteRoot = root;
        if (this.paletteRoot != null) {
            EditPart palette = this.getEditPartFactory().createEditPart(this.getRootEditPart(), root);
            this.getRootEditPart().setContents(palette);
        }
    }

    public void setSelection(PaletteEntry entry) {
        if (this.selectedEntry == entry) {
            return;
        }
        if (entry == null) {
            this.getButtonGroup().setSelected(null);
            this.selectedEntry = null;
            this.getButtonGroup().setSelected(this.getButtonGroup().getDefault());
            if (this.getButtonGroup().getSelected() == null) {
                this.selectedEntry = null;
                this.firePaletteSelectionChanged();
            }
        } else {
            this.selectedEntry = entry;
            EntryEditPart ep = (EntryEditPart)this.getEditPartRegistry().get(entry);
            ep.select();
            this.firePaletteSelectionChanged();
        }
    }
}

