/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.gef.ui.palette.DropShadowButtonBorder;
import org.eclipse.gef.ui.palette.ImageConstants;
import org.eclipse.swt.graphics.Image;

public final class PaletteScrollBar
extends ScrollBar {
    protected Label upLabel;
    protected Label downLabel;
    private static Border dropshadow = new DropShadowButtonBorder();
    private static Border margin = new MarginBorder(2, 0, 2, 2);

    public PaletteScrollBar() {
        this.setBorder(margin);
        this.setPreferredSize(15, 15);
    }

    protected Clickable createDefaultDownButton() {
        this.downLabel = new Label(ImageConstants.down);
        this.downLabel.setOpaque(true);
        this.downLabel.setIconAlignment(32);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PaletteScrollBar.this.updateDownLabel();
            }
        });
        Clickable button = new Clickable((IFigure)this.downLabel);
        button.setRequestFocusEnabled(false);
        button.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                PaletteScrollBar.this.updateDownLabel();
            }
        });
        button.setFiringMethod(1);
        button.setRolloverEnabled(true);
        button.setBorder(dropshadow);
        button.setOpaque(false);
        return button;
    }

    protected Clickable createDefaultUpButton() {
        this.upLabel = new Label(ImageConstants.up);
        this.upLabel.setOpaque(true);
        this.upLabel.setIconAlignment(32);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PaletteScrollBar.this.updateUpLabel();
            }
        });
        Clickable button = new Clickable((IFigure)this.upLabel);
        button.setRequestFocusEnabled(false);
        button.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                PaletteScrollBar.this.updateUpLabel();
            }
        });
        button.setFiringMethod(1);
        button.setRolloverEnabled(true);
        button.setBorder(dropshadow);
        button.setOpaque(false);
        return button;
    }

    protected void initialize() {
        super.initialize();
        this.setPageUp(null);
        this.setPageDown(null);
        this.setThumb(null);
        this.setOpaque(false);
    }

    protected void updateDownLabel() {
        Image icon = null;
        if (((Clickable)this.getButtonDown()).getModel().isPressed() || !((Clickable)this.getButtonDown()).getModel().isMouseOver()) {
            icon = ImageConstants.downPressed;
        }
        if (this.getValue() >= this.getMaximum() - this.getExtent()) {
            icon = ImageConstants.downGrayed;
            this.getButtonDown().setEnabled(false);
        } else {
            this.getButtonDown().setEnabled(true);
            if (icon == null) {
                icon = ImageConstants.down;
            }
        }
        this.downLabel.setIcon(icon);
    }

    protected void updateUpLabel() {
        Image icon = null;
        if (((Clickable)this.getButtonUp()).getModel().isPressed() || !((Clickable)this.getButtonUp()).getModel().isMouseOver()) {
            icon = ImageConstants.upPressed;
        }
        if (this.getValue() <= this.getMinimum()) {
            icon = ImageConstants.upGrayed;
            this.getButtonUp().setEnabled(false);
        } else {
            this.getButtonUp().setEnabled(true);
            if (icon == null) {
                icon = ImageConstants.up;
            }
        }
        this.upLabel.setIcon(icon);
    }
}

