/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonGroup;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.EditPartTipHelper;
import org.eclipse.gef.ui.palette.PaletteEditPart;
import org.eclipse.gef.ui.palette.PaletteEntryBorder;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class EntryEditPart
extends PaletteEditPart {
    private static final Color COLOR_ENTRY_SELECTED = ColorConstants.button;
    private static final Border BORDER_LABEL_MARGIN = new MarginBorder(new Insets(1, 1, 1, 2));
    private ToggleButton toolTipButton;

    public EntryEditPart(PaletteEntry paletteEntry) {
        this.setModel(paletteEntry);
    }

    public void activate() {
        super.activate();
        final Clickable button = (Clickable)this.getFigure();
        final Label buttonLabel = (Label)button.getChildren().get(0);
        final Control ctrl = this.getViewer().getControl();
        button.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){
            private EditPartTipHelper tipHelper;

            public void mouseEntered(MouseEvent e) {
                if (buttonLabel.isTextTruncated()) {
                    this.tipHelper = new EditPartTipHelper(ctrl);
                    this.tipHelper.setBackgroundColor(button.getParent().getBackgroundColor());
                    Point buttonLoc = button.getLocation();
                    org.eclipse.swt.graphics.Point absolute = ctrl.toDisplay(new org.eclipse.swt.graphics.Point(buttonLoc.x, buttonLoc.y));
                    EntryEditPart.this.toolTipButton.getModel().setMouseOver(true);
                    EntryEditPart.this.toolTipButton.getModel().setSelected(button.isSelected());
                    this.tipHelper.displayToolTipAt((IFigure)EntryEditPart.this.toolTipButton, absolute.x, absolute.y);
                }
            }
        });
        button.addFocusListener((FocusListener)new FocusListener.Stub(){

            public void focusGained(FocusEvent fe) {
                EntryEditPart.this.getRoot().getViewer().select(EntryEditPart.this);
            }
        });
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getDescription(AccessibleEvent e) {
                e.result = EntryEditPart.this.getPaletteEntry().getDescription();
            }

            public void getName(AccessibleEvent e) {
                e.result = EntryEditPart.this.getPaletteEntry().getLabel();
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = EntryEditPart.this.getButtonModel().isSelected() ? 2 : 0x200000;
            }
        };
    }

    public IFigure createFigure() {
        ToggleButton button = new ToggleButton((IFigure)this.createLabel()){

            protected void paintFigure(Graphics graphics) {
                if (this.isOpaque()) {
                    graphics.fillRectangle(this.getClientArea());
                }
            }
        };
        button.setBorder((Border)new PaletteEntryBorder());
        button.setRolloverEnabled(true);
        button.setBackgroundColor(COLOR_ENTRY_SELECTED);
        button.setOpaque(false);
        button.addChangeListener(new ChangeListener((Clickable)button){
            private final /* synthetic */ Clickable val$button;
            {
                this.val$button = clickable;
            }

            public void handleStateChanged(ChangeEvent e) {
                if (e.getPropertyName().equals("selected")) {
                    this.val$button.setOpaque(this.val$button.isSelected());
                    this.val$button.setForegroundColor((Color)(this.val$button.isSelected() ? ColorConstants.black : null));
                    if (this.val$button.isSelected()) {
                        EntryEditPart.this.getPaletteViewer().setSelection(EntryEditPart.this.getPaletteEntry());
                    }
                }
            }
        });
        return button;
    }

    protected Figure createLabel() {
        Label label = new Label();
        label.setLabelAlignment(1);
        label.setBorder(BORDER_LABEL_MARGIN);
        return label;
    }

    private void createToolTipButton() {
        final ToggleButton tipButton = (ToggleButton)this.createFigure();
        this.setToolTipButton(tipButton);
        tipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Clickable)EntryEditPart.this.getFigure()).doClick();
                ((Clickable)EntryEditPart.this.getFigure()).requestFocus();
                tipButton.setSelected(((Clickable)EntryEditPart.this.getFigure()).isSelected());
            }
        });
    }

    private ButtonGroup getButtonGroup() {
        PaletteViewer pv = (PaletteViewer)this.getViewer();
        return pv.getButtonGroup();
    }

    private ButtonModel getButtonModel() {
        Clickable c = (Clickable)this.getFigure();
        return c.getModel();
    }

    private PaletteEntry getPaletteEntry() {
        return (PaletteEntry)this.getModel();
    }

    private PaletteViewer getPaletteViewer() {
        return (PaletteViewer)this.getViewer();
    }

    private ToggleButton getToolTipButton() {
        if (this.toolTipButton == null) {
            this.createToolTipButton();
        }
        return this.toolTipButton;
    }

    protected void refreshVisuals() {
        PaletteEntry entryModel = (PaletteEntry)this.getModel();
        Clickable button = (Clickable)this.getFigure();
        Label buttonLabel = (Label)button.getChildren().get(0);
        Label toolTipButtonLabel = (Label)this.getToolTipButton().getChildren().get(0);
        buttonLabel.setText(entryModel.getLabel());
        buttonLabel.setIcon(entryModel.getSmallIcon());
        toolTipButtonLabel.setText(entryModel.getLabel());
        toolTipButtonLabel.setIcon(entryModel.getSmallIcon());
        String desc = entryModel.getDescription();
        if (desc != null && !desc.equals("") && !desc.equals(entryModel.getLabel())) {
            button.setToolTip((IFigure)new Label(desc));
            this.getToolTipButton().setToolTip((IFigure)new Label(desc));
        }
    }

    protected void register() {
        super.register();
        this.getButtonGroup().add(this.getButtonModel());
        if (this.getPaletteEntry().isDefault()) {
            this.getButtonGroup().setDefault(this.getButtonModel());
        }
    }

    public void select() {
        this.getButtonModel().setSelected(true);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value == 2) {
            this.getFigure().requestFocus();
        }
    }

    private void setToolTipButton(ToggleButton button) {
        this.toolTipButton = button;
    }

    protected void unregister() {
        this.getButtonGroup().remove(this.getButtonModel());
        super.unregister();
    }
}

