/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

class EditPartTipHelper
extends PopUpHelper {
    private static EditPartTipHelper currentHelper;

    private static void setHelper(EditPartTipHelper helper) {
        if (currentHelper != null && currentHelper != helper && currentHelper.isShowing()) {
            currentHelper.hide();
        }
        currentHelper = helper;
    }

    public EditPartTipHelper(Control c) {
        super(c);
    }

    public void displayToolTipAt(IFigure tip, int tipPosX, int tipPosY) {
        if (tip != null) {
            EditPartTipHelper.setHelper(this);
            this.getLightweightSystem().setContents(tip);
            Dimension tipSize = tip.getPreferredSize();
            this.setShellBounds(tipPosX, tipPosY, tipSize.width, tipSize.height);
            this.show();
            this.getShell().setCapture(true);
        }
    }

    protected void hookShellListeners() {
        this.getShell().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                EditPartTipHelper.super.getShell().setCapture(false);
                EditPartTipHelper.this.dispose();
            }
        });
        this.getShell().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point eventPoint = EditPartTipHelper.super.getShell().toDisplay(new Point(e.x, e.y));
                if (!EditPartTipHelper.super.getShell().getBounds().contains(eventPoint)) {
                    if (EditPartTipHelper.this.isShowing()) {
                        EditPartTipHelper.super.getShell().setCapture(false);
                    }
                    EditPartTipHelper.this.dispose();
                }
            }
        });
    }
}

