/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.ui.palette.AnimatableFigure;
import org.eclipse.gef.ui.palette.CategoryToolTipBorder;
import org.eclipse.gef.ui.palette.EditPartTipHelper;
import org.eclipse.gef.ui.palette.GroupEditPart;
import org.eclipse.gef.ui.palette.OverlayScrollPaneLayout;
import org.eclipse.gef.ui.palette.PaletteEditPart;
import org.eclipse.gef.ui.palette.PaletteScrollBar;
import org.eclipse.gef.ui.palette.SeparatorBorder;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class CategoryEditPart
extends PaletteEditPart {
    private ScrollPane scrollpane = null;
    private Toggle collapseToggle = null;
    private Orientable arrow = null;
    private Label categoryLabel = null;
    private static final Border BORDER_TITLE_MARGIN = new MarginBorder(2, 5, 2, 2);
    private static final Color COLOR_TITLE_BACKGROUND = FigureUtilities.mixColors((Color)ColorConstants.button, (Color)ColorConstants.white);
    static /* synthetic */ Class class$0;

    public CategoryEditPart(PaletteContainer category) {
        this.setModel(category);
    }

    public void activate() {
        super.activate();
        final Label tipLabel = new Label(this.categoryLabel.getText(), this.categoryLabel.getIcon());
        final Control ctrl = this.getViewer().getControl();
        tipLabel.setOpaque(true);
        tipLabel.setBackgroundColor(ColorConstants.tooltipBackground);
        tipLabel.setForegroundColor(ColorConstants.tooltipForeground);
        tipLabel.setBorder((Border)new CategoryToolTipBorder());
        this.collapseToggle.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){
            private EditPartTipHelper tipHelper;

            public void mouseMoved(MouseEvent e) {
                Rectangle labelBounds = CategoryEditPart.this.categoryLabel.getBounds();
                if (CategoryEditPart.this.categoryLabel.isTextTruncated() && labelBounds.contains(e.x, e.y)) {
                    if (this.tipHelper == null) {
                        this.tipHelper = new EditPartTipHelper(ctrl);
                        Point labelLoc = CategoryEditPart.this.categoryLabel.getLocation();
                        org.eclipse.swt.graphics.Point absolute = ctrl.toDisplay(new org.eclipse.swt.graphics.Point(labelLoc.x, labelLoc.y));
                        this.tipHelper.displayToolTipAt((IFigure)tipLabel, absolute.x - 2, absolute.y - 5);
                    } else {
                        this.tipHelper = null;
                    }
                }
            }
        });
        this.collapseToggle.addFocusListener((FocusListener)new FocusListener.Stub(){

            public void focusGained(FocusEvent fe) {
                CategoryEditPart.this.getRoot().getViewer().select(CategoryEditPart.this);
            }
        });
        tipLabel.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent e) {
                if (!CategoryEditPart.this.collapseToggle.isSelected()) {
                    CategoryEditPart.this.collapseToggle.setSelected(true);
                } else {
                    CategoryEditPart.this.collapseToggle.setSelected(false);
                }
            }
        });
    }

    private Figure createCollapseLabel() {
        Figure figure = new Figure();
        figure.setForegroundColor(ColorConstants.black);
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setSpacing(2);
        layout.setMinorAlignment(0);
        figure.setLayoutManager((LayoutManager)layout);
        this.arrow = PaletteEditPart.getArrowRight();
        figure.add((IFigure)this.arrow);
        this.categoryLabel = new Label();
        this.categoryLabel.setLabelAlignment(1);
        figure.add((IFigure)this.categoryLabel);
        return figure;
    }

    private Toggle createCollapseToggle() {
        Toggle toggle = new Toggle((IFigure)this.createCollapseLabel());
        toggle.setBackgroundColor(COLOR_TITLE_BACKGROUND);
        toggle.setOpaque(true);
        toggle.setSelected(true);
        toggle.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                if (event.getPropertyName().equals("selected")) {
                    CategoryEditPart.this.refreshVisuals(true);
                }
            }
        });
        toggle.setBorder(BORDER_TITLE_MARGIN);
        return toggle;
    }

    public IFigure createFigure() {
        AnimatableFigure mainFigure = new AnimatableFigure();
        mainFigure.setBackgroundColor(ColorConstants.white);
        mainFigure.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.collapseToggle = this.createCollapseToggle();
        this.scrollpane = new ScrollPane();
        this.scrollpane.getViewport().setContentsTracksWidth(true);
        this.scrollpane.setMinimumSize(new Dimension(0, 0));
        this.scrollpane.setHorizontalScrollBarVisibility(0);
        this.scrollpane.setVerticalScrollBar((ScrollBar)new PaletteScrollBar());
        this.scrollpane.getVerticalScrollBar().setStepIncrement(22);
        this.scrollpane.setLayoutManager((LayoutManager)new OverlayScrollPaneLayout());
        this.scrollpane.setView((IFigure)new Figure());
        this.scrollpane.getView().setLayoutManager((LayoutManager)new ToolbarLayout());
        mainFigure.add((IFigure)this.collapseToggle);
        mainFigure.add((IFigure)this.scrollpane);
        return mainFigure;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ExposeHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new ViewportExposeHelper(this);
        }
        return super.getAdapter(key);
    }

    private PaletteContainer getCategory() {
        return (PaletteContainer)this.getModel();
    }

    public IFigure getContentPane() {
        return this.scrollpane.getView();
    }

    public boolean isExpanded() {
        return this.collapseToggle.isSelected();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (index > 0 && childEditPart instanceof GroupEditPart) {
            ((GroupEditPart)childEditPart).getFigure().setBorder((Border)new SeparatorBorder());
        }
        super.addChildVisual(childEditPart, index);
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getDescription(AccessibleEvent e) {
                e.result = CategoryEditPart.this.getCategory().getDescription();
            }

            public void getName(AccessibleEvent e) {
                e.result = CategoryEditPart.this.getCategory().getLabel();
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 35;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = CategoryEditPart.this.isExpanded() ? 512 : 1024;
            }
        };
    }

    public void refreshChildren() {
        super.refreshChildren();
    }

    private void refreshTitle() {
        this.categoryLabel.setText(this.getCategory().getLabel());
        this.categoryLabel.setIcon(this.getCategory().getSmallIcon());
    }

    protected void refreshVisuals() {
        this.refreshVisuals(false);
    }

    protected void refreshVisuals(boolean animate) {
        this.refreshTitle();
        if (this.collapseToggle.isSelected()) {
            this.scrollpane.setVisible(true);
            this.arrow.setDirection(4);
            this.scrollpane.setVerticalScrollBarVisibility(0);
            if (animate) {
                ((AnimatableFigure)this.getFigure()).expand();
            } else {
                ((AnimatableFigure)this.getFigure()).setExpanded(true);
            }
            this.scrollpane.setVerticalScrollBarVisibility(1);
        } else {
            this.arrow.setDirection(16);
            this.scrollpane.setVerticalScrollBarVisibility(0);
            if (animate) {
                ((AnimatableFigure)this.getFigure()).collapse();
            } else {
                ((AnimatableFigure)this.getFigure()).setExpanded(false);
            }
            this.scrollpane.setVisible(false);
        }
    }

    public void setExpanded(boolean expanded) {
        if (expanded == this.collapseToggle.isSelected()) {
            return;
        }
        this.collapseToggle.setSelected(expanded);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value == 2) {
            this.collapseToggle.requestFocus();
        }
    }
}

