/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.ui.palette.AnimationModel;

class AnimatableFigure
extends Figure {
    private AnimationModel animationModel = null;
    protected boolean expanded = true;
    private static final long delay = 150L;

    private void animate() {
        this.animationModel = new AnimationModel(150L, this.expanded);
        this.animationModel.animationStarted();
        while (!this.animationModel.isFinished()) {
            this.step();
        }
        this.step();
        this.animationModel = null;
    }

    public void collapse() {
        if (!this.expanded) {
            return;
        }
        this.expanded = false;
        this.animate();
    }

    public void expand() {
        if (this.expanded) {
            return;
        }
        this.expanded = true;
        this.animate();
    }

    public Dimension getPreferredSize() {
        if (this.animationModel == null) {
            if (this.expanded) {
                return super.getPreferredSize();
            }
            return this.getMinimumSize();
        }
        Dimension pref = super.getPreferredSize();
        Dimension min = this.getMinimumSize();
        float scale = this.animationModel.getProgress();
        return pref.getScaled(scale).expand(min.getScaled(1.0f - scale));
    }

    public void setExpanded(boolean value) {
        if (this.expanded == value) {
            return;
        }
        this.expanded = value;
        this.revalidate();
    }

    private void step() {
        this.revalidate();
        this.getUpdateManager().performUpdate();
    }
}

