/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.text.MessageFormat;
import java.util.EventObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.WorkbenchImages;

public class UndoAction
extends StackAction {
    public UndoAction(IEditorPart editor) {
        super(editor);
    }

    public void commandStackChanged(EventObject e) {
        this.refresh();
    }

    protected boolean calculateEnabled() {
        return this.getCommandStack().canUndo();
    }

    protected void init() {
        super.init();
        this.setToolTipText(MessageFormat.format(GEFMessages.UndoAction_ToolTipText, "").trim());
        this.setText(String.valueOf(MessageFormat.format(GEFMessages.UndoAction_ActionLabelText, "").trim()) + GEFMessages.UndoAction_ActionShortcutText);
        this.setId("undo");
        this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_UNDO_EDIT_HOVER"));
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_UNDO_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_UNDO_EDIT_DISABLED"));
    }

    protected void refresh() {
        Command undoCmd = this.getCommandStack().getUndoCommand();
        this.setToolTipText(MessageFormat.format(GEFMessages.UndoAction_ToolTipText, this.getLabelForCommand(undoCmd)).trim());
        this.setText(String.valueOf(MessageFormat.format(GEFMessages.UndoAction_ActionLabelText, this.getLabelForCommand(undoCmd)).trim()) + GEFMessages.UndoAction_ActionShortcutText);
        super.refresh();
    }

    public void run() {
        this.getCommandStack().undo();
    }
}

