/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SelectionAction
extends EditorPartAction
implements ISelectionListener {
    private ISelection selection;

    public SelectionAction(IEditorPart editor, int style) {
        super(editor, style);
    }

    public SelectionAction(IEditorPart editor) {
        super(editor);
    }

    public void dispose() {
        this.selection = StructuredSelection.EMPTY;
        super.dispose();
    }

    protected ISelection getSelection() {
        if (this.isDynamic()) {
            return this.selection;
        }
        return this.getEditorPart().getSite().getPage().getSelection();
    }

    protected List getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    protected void handleSelectionChanged() {
        this.refresh();
    }

    protected void hookEditorPart() {
        this.getEditorPart().getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setSelection(selection);
    }

    protected void setSelection(ISelection selection) {
        this.selection = selection;
        this.handleSelectionChanged();
    }

    protected void unhookEditorPart() {
        this.getEditorPart().getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }
}

