/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.text.MessageFormat;
import java.util.EventObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.WorkbenchImages;

public class RedoAction
extends StackAction {
    public RedoAction(IEditorPart editor) {
        super(editor);
    }

    public void commandStackChanged(EventObject e) {
        this.refresh();
    }

    protected boolean calculateEnabled() {
        return this.getCommandStack().canRedo();
    }

    protected void init() {
        super.init();
        this.setToolTipText(MessageFormat.format(GEFMessages.RedoAction_ActionToolTipText, "").trim());
        this.setText(String.valueOf(MessageFormat.format(GEFMessages.RedoAction_ActionLabelText, "").trim()) + GEFMessages.RedoAction_ActionShortcutText);
        this.setId("redo");
        this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_REDO_EDIT_HOVER"));
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_REDO_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_REDO_EDIT_DISABLED"));
    }

    protected void refresh() {
        Command redoCmd = this.getCommandStack().getRedoCommand();
        this.setToolTipText(MessageFormat.format(GEFMessages.RedoAction_ActionToolTipText, this.getLabelForCommand(redoCmd)).trim());
        this.setText(String.valueOf(MessageFormat.format(GEFMessages.RedoAction_ActionLabelText, this.getLabelForCommand(redoCmd)).trim()) + GEFMessages.RedoAction_ActionShortcutText);
        super.refresh();
    }

    public void run() {
        this.getCommandStack().redo();
    }
}

