/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class DirectEditAction
extends SelectionAction {
    private Request directEditRequest = new Request("direct edit");
    public static final String ID = "$direct edit";

    public DirectEditAction(IEditorPart editor) {
        super(editor);
    }

    public DirectEditAction(IEditorPart editor, int style) {
        super(editor, style);
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof EditPart) {
            EditPart part = (EditPart)this.getSelectedObjects().get(0);
            return part.understandsRequest(this.getDirectEditRequest());
        }
        return false;
    }

    protected Request getDirectEditRequest() {
        return this.directEditRequest;
    }

    public void run() {
        try {
            EditPart part = (EditPart)this.getSelectedObjects().get(0);
            part.performRequest(this.getDirectEditRequest());
        }
        catch (ClassCastException e) {
            Display.getCurrent().beep();
        }
        catch (IndexOutOfBoundsException e) {
            Display.getCurrent().beep();
        }
    }

    public void setDirectEditRequest(Request req) {
        this.directEditRequest = req;
    }

    protected void init() {
        super.init();
        this.setText(GEFMessages.RenameAction_ActionLabelText);
        this.setToolTipText(GEFMessages.RenameAction_ActionToolTipText);
        this.setId(ID);
    }
}

