/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.DeleteRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.WorkbenchImages;

public final class DeleteAction
extends SelectionAction {
    public static final String ID = "delete";

    public DeleteAction(IEditorPart editor, int style) {
        super(editor, style);
    }

    public DeleteAction(IEditorPart editor) {
        super(editor);
    }

    public DeleteAction(IEditorPart editor, int style, String label) {
        super(editor, style);
        this.setText(label);
        this.setToolTipText(label);
    }

    protected void init() {
        super.init();
        this.setText(GEFMessages.DeleteAction_ActionLabelText);
        this.setToolTipText(GEFMessages.DeleteAction_ActionToolTipText);
        this.setId(ID);
        this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_DELETE_EDIT_HOVER"));
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_DELETE_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_CTOOL_DELETE_EDIT_DISABLED"));
        this.setEnabled(false);
    }

    public DeleteAction(IEditorPart editor, String label) {
        super(editor);
        this.setText(label);
    }

    public static Command createDeleteCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        DeleteRequest deleteReq = new DeleteRequest(ID);
        CompoundCommand compoundCmd = new CompoundCommand(GEFMessages.DeleteAction_ActionDeleteCommandName);
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            Command cmd = object.getCommand(deleteReq);
            if (cmd != null) {
                compoundCmd.add(cmd);
            }
            ++i;
        }
        return compoundCmd;
    }

    protected boolean calculateEnabled() {
        Command cmd = DeleteAction.createDeleteCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        this.execute(DeleteAction.createDeleteCommand(this.getSelectedObjects()));
    }
}

