/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.SharedImages;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;

public final class AlignmentAction
extends SelectionAction {
    public static String ID_ALIGN_LEFT = "$align left";
    public static String ID_ALIGN_RIGHT = "$align right";
    public static String ID_ALIGN_TOP = "$align top";
    public static String ID_ALIGN_BOTTOM = "$align bottom";
    public static String ID_ALIGN_CENTER = "$align center";
    public static String ID_ALIGN_MIDDLE = "$align middle";
    private List operationSet;
    private int alignment;

    public AlignmentAction(IEditorPart editor, int style, int align) {
        super(editor, style);
        this.alignment = align;
        this.init();
    }

    public AlignmentAction(IEditorPart editor, int align) {
        super(editor);
        this.alignment = align;
        this.init();
    }

    protected boolean calculateEnabled() {
        this.operationSet = null;
        Command cmd = this.createAlignmentCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    protected Rectangle calculateAlignmentRectangle(Request request) {
        List editparts = this.getOperationSet(request);
        if (editparts == null || editparts.isEmpty()) {
            return null;
        }
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(editparts.size() - 1);
        return part.getFigure().getBounds();
    }

    private Command createAlignmentCommand() {
        AlignmentRequest request = new AlignmentRequest("align");
        request.setAlignmentRectangle(this.calculateAlignmentRectangle(request));
        request.setAlignment(this.alignment);
        List editparts = this.getOperationSet(request);
        if (editparts.size() < 2) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            command.add(editpart.getCommand(request));
            ++i;
        }
        return command;
    }

    public void dispose() {
        this.operationSet = Collections.EMPTY_LIST;
        super.dispose();
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return super.getHoverImageDescriptor();
    }

    protected List getOperationSet(Request request) {
        if (this.operationSet != null) {
            return this.operationSet;
        }
        List editparts = new ArrayList(this.getSelectedObjects());
        if (editparts.isEmpty() || !(editparts.get(0) instanceof GraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        editparts = ToolUtilities.getSelectionWithoutDependants(editparts);
        ToolUtilities.filterEditPartsUnderstanding(editparts, request);
        if (editparts.size() < 2) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected void init() {
        super.init();
        switch (this.alignment) {
            case 1: {
                this.setId(ID_ALIGN_LEFT);
                this.setText(GEFMessages.AlignLeftAction_ActionLabelText);
                this.setToolTipText(GEFMessages.AlignLeftAction_ActionToolTipText);
                this.setImageDescriptor(SharedImages.DESC_HORZ_ALIGN_LEFT);
                break;
            }
            case 4: {
                this.setId(ID_ALIGN_RIGHT);
                this.setText(GEFMessages.AlignRightAction_ActionLabelText);
                this.setToolTipText(GEFMessages.AlignRightAction_ActionToolTipText);
                this.setImageDescriptor(SharedImages.DESC_HORZ_ALIGN_RIGHT);
                break;
            }
            case 8: {
                this.setId(ID_ALIGN_TOP);
                this.setText(GEFMessages.AlignTopAction_ActionLabelText);
                this.setToolTipText(GEFMessages.AlignTopAction_ActionToolTipText);
                this.setImageDescriptor(SharedImages.DESC_VERT_ALIGN_TOP);
                break;
            }
            case 32: {
                this.setId(ID_ALIGN_BOTTOM);
                this.setText(GEFMessages.AlignBottomAction_ActionLabelText);
                this.setToolTipText(GEFMessages.AlignBottomAction_ActionToolTipText);
                this.setImageDescriptor(SharedImages.DESC_VERT_ALIGN_BOTTOM);
                break;
            }
            case 2: {
                this.setId(ID_ALIGN_CENTER);
                this.setText(GEFMessages.AlignCenterAction_ActionLabelText);
                this.setToolTipText(GEFMessages.AlignCenterAction_ActionToolTipText);
                this.setImageDescriptor(SharedImages.DESC_HORZ_ALIGN_CENTER);
                break;
            }
            case 16: {
                this.setId(ID_ALIGN_MIDDLE);
                this.setText(GEFMessages.AlignMiddleAction_ActionLabelText);
                this.setToolTipText(GEFMessages.AlignMiddleAction_ActionToolTipText);
                this.setImageDescriptor(SharedImages.DESC_VERT_ALIGN_MIDDLE);
            }
        }
    }

    public void run() {
        this.operationSet = null;
        this.execute(this.createAlignmentCommand());
    }
}

