/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class SelectionTool
extends TargetingTool {
    private static final int FLAG_HOVER_FEEDBACK = 64;
    protected static final int MAX_FLAG = 64;
    protected static final int STATE_TRAVERSE_HANDLE = 64;
    protected static final int MAX_STATE = 64;
    private int handleIndex;
    private DragTracker dragTracker;
    private LocationRequest hoverRequest;
    private WeakReference cachedHandlePart;
    static /* synthetic */ Class class$0;

    private boolean acceptTraverseHandle(KeyEvent e) {
        return (e.character == '.' || e.character == '>') && this.isInState(49) && (e.stateMask & 0x50000) == 0;
    }

    protected void createHoverRequest() {
        this.hoverRequest = new LocationRequest();
        this.hoverRequest.setType("selection hover");
    }

    protected Request createTargetRequest() {
        SelectionRequest request = new SelectionRequest();
        request.setType(this.getCommandName());
        return request;
    }

    public void deactivate() {
        this.setDragTracker(null);
        super.deactivate();
    }

    protected void eraseHoverFeedback() {
        if (this.getTargetEditPart() == null) {
            return;
        }
        if (this.getTargetHoverRequest() == null) {
            return;
        }
        this.getTargetEditPart().eraseTargetFeedback(this.getTargetHoverRequest());
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Selection Tool";
    }

    protected DragTracker getDragTracker() {
        return this.dragTracker;
    }

    private EditPart getLastHandleProvider() {
        if (this.cachedHandlePart == null) {
            return null;
        }
        EditPart part = (EditPart)this.cachedHandlePart.get();
        if (this.cachedHandlePart.isEnqueued()) {
            return null;
        }
        return part;
    }

    protected Request getTargetHoverRequest() {
        if (this.hoverRequest == null) {
            this.createHoverRequest();
        }
        return this.hoverRequest;
    }

    protected boolean handleButtonDown(int button) {
        Handle handle;
        if (!this.stateTransition(1, 2)) {
            this.resetHover();
            return true;
        }
        this.resetHover();
        EditPartViewer viewer = this.getCurrentViewer();
        Point p = this.getLocation();
        if (this.getDragTracker() != null) {
            this.getDragTracker().deactivate();
        }
        if (viewer instanceof GraphicalViewer && (handle = ((GraphicalViewer)viewer).findHandleAt(p)) != null) {
            this.setDragTracker(handle.getDragTracker());
            return true;
        }
        this.updateTargetUnderMouse();
        EditPart editpart = this.getTargetEditPart();
        if (editpart != null) {
            this.setDragTracker(editpart.getDragTracker(this.getTargetRequest()));
            this.lockTargetEditPart(editpart);
            return true;
        }
        return false;
    }

    protected boolean handleButtonUp(int button) {
        if (this.getCurrentInput().isAnyButtonDown()) {
            return false;
        }
        this.setDragTracker(null);
        this.setState(1);
        this.unlockTargetEditPart();
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(48)) {
            if (this.getDragTracker() != null) {
                this.setDragTracker(null);
            }
            this.setState(1);
            return true;
        }
        return false;
    }

    protected boolean handleHover() {
        this.setHoverActive(true);
        this.showHoverFeedback();
        return true;
    }

    protected boolean handleHoverStop() {
        this.eraseHoverFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        this.resetHover();
        if (this.acceptArrowKey(e) && this.stateTransition(16, 32)) {
            return true;
        }
        if (this.acceptAbort(e)) {
            if (this.getDragTracker() != null) {
                this.setDragTracker(null);
            }
            if (this.isInState(112)) {
                this.placeMouseInViewer(this.getStartLocation().getTranslated(6, 6));
            }
            this.setState(1);
            this.setLastHandleProvider(null);
            return true;
        }
        if (this.acceptTraverseHandle(e)) {
            if (this.isInState(32) && this.getDragTracker() != null) {
                this.getDragTracker().commitDrag();
            }
            if (this.isInState(48)) {
                this.setDragTracker(null);
                this.getCurrentViewer().flush();
            }
            if (!this.handleTraverseHandle(e)) {
                this.setState(1);
            }
            return true;
        }
        if (this.acceptDragCommit(e)) {
            if (this.getDragTracker() != null) {
                this.getDragTracker().commitDrag();
            }
            this.setDragTracker(null);
            this.setState(1);
            --this.handleIndex;
            this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
            return true;
        }
        return this.isInState(1) && this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        return this.isInState(1) && this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyReleased(e);
    }

    protected boolean handleMove() {
        EditPartViewer viewer;
        if (this.stateTransition(16, 1)) {
            this.setDragTracker(null);
        }
        if (this.isInState(1)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showTargetFeedback();
            return true;
        }
        if (this.isInState(64) && (viewer = this.getCurrentViewer()) instanceof GraphicalViewer) {
            Handle handle = ((GraphicalViewer)viewer).findHandleAt(this.getLocation());
            if (handle != null) {
                this.setState(16);
                this.setStartLocation(this.getLocation());
                this.setDragTracker(handle.getDragTracker());
                return true;
            }
            this.setState(1);
        }
        return false;
    }

    private boolean handleTraverseHandle(KeyEvent e) {
        AccessibleHandleProvider provider;
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        if (focus.getSelected() == 0) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.AccessibleHandleProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((provider = (AccessibleHandleProvider)focus.getAdapter(clazz)) == null || provider.getAccessibleHandleLocations().isEmpty()) {
            return false;
        }
        this.setState(64);
        List locations = provider.getAccessibleHandleLocations();
        if (e.character == '.') {
            ++this.handleIndex;
            this.handleIndex %= locations.size();
        } else {
            this.handleIndex = (--this.handleIndex + locations.size()) % locations.size();
        }
        if (this.getLastHandleProvider() != focus) {
            this.handleIndex = 0;
            this.setLastHandleProvider(focus);
        }
        Point loc = (Point)locations.get(this.handleIndex);
        this.placeMouseInViewer(loc);
        return true;
    }

    protected boolean handleViewerExited() {
        if (this.isInState(54)) {
            if (this.getDragTracker() != null) {
                this.setDragTracker(null);
            }
            this.setState(1);
        }
        return super.handleViewerExited();
    }

    public void keyDown(KeyEvent evt, EditPartViewer viewer) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().keyDown(evt, viewer);
        }
        super.keyDown(evt, viewer);
    }

    public void keyUp(KeyEvent evt, EditPartViewer viewer) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().keyUp(evt, viewer);
        }
        super.keyUp(evt, viewer);
    }

    public void mouseDown(MouseEvent e, EditPartViewer viewer) {
        super.mouseDown(e, viewer);
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseDown(e, viewer);
        }
    }

    public void mouseDoubleClick(MouseEvent e, EditPartViewer viewer) {
        super.mouseDoubleClick(e, viewer);
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseDoubleClick(e, viewer);
        }
    }

    public void mouseDrag(MouseEvent e, EditPartViewer viewer) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseDrag(e, viewer);
        }
        super.mouseDrag(e, viewer);
    }

    public void mouseHover(MouseEvent me, EditPartViewer viewer) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseHover(me, viewer);
        }
        super.mouseHover(me, viewer);
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseMove(me, viewer);
        }
        super.mouseMove(me, viewer);
    }

    public void mouseUp(MouseEvent e, EditPartViewer viewer) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseUp(e, viewer);
        }
        super.mouseUp(e, viewer);
    }

    protected void refreshCursor() {
        if (this.getDragTracker() == null) {
            super.refreshCursor();
        }
    }

    public void setDragTracker(DragTracker newDragTracker) {
        if (newDragTracker == this.dragTracker) {
            return;
        }
        if (this.dragTracker != null) {
            this.dragTracker.deactivate();
        }
        this.dragTracker = newDragTracker;
        this.refreshCursor();
        this.setMouseCapture(this.dragTracker != null);
        if (newDragTracker != null) {
            newDragTracker.setEditDomain(this.getDomain());
            newDragTracker.activate();
            newDragTracker.setViewer(this.getCurrentViewer());
        }
    }

    private void setLastHandleProvider(EditPart part) {
        this.cachedHandlePart = part == null ? null : new WeakReference<EditPart>(part);
    }

    protected void showHoverFeedback() {
        if (this.getTargetEditPart() == null) {
            return;
        }
        if (this.getTargetHoverRequest() == null) {
            return;
        }
        this.getTargetEditPart().showTargetFeedback(this.getTargetHoverRequest());
    }

    protected void updateHoverRequest() {
        LocationRequest request = (LocationRequest)this.getTargetHoverRequest();
        request.setLocation(this.getLocation());
    }

    protected void updateTargetRequest() {
        SelectionRequest request = (SelectionRequest)this.getTargetRequest();
        request.setModifiers(this.getCurrentInput().getModifiers());
        request.setType(this.getCommandName());
        request.setLocation(this.getLocation());
        this.updateHoverRequest();
    }

    protected String getDebugNameForState(int state) {
        if (state == 64) {
            return "Traverse Handle";
        }
        return super.getDebugNameForState(state);
    }
}

