/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.graphics.Cursor;

public class SelectEditPartTracker
extends TargetingTool
implements DragTracker {
    protected static final int FLAG_SELECTION_PERFORMED = 64;
    protected static final int MAX_FLAG = 64;
    private EditPart editpart;

    public SelectEditPartTracker(EditPart owner) {
        this.setSourceEditPart(owner);
    }

    protected Cursor calculateCursor() {
        if (this.isInState(19)) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    protected String getCommandName() {
        return "Select Tracker";
    }

    protected String getDebugName() {
        return "Select Tracker";
    }

    protected EditPart getSourceEditPart() {
        return this.editpart;
    }

    protected boolean handleButtonDown(int button) {
        if ((button == 3 || button == 1) && this.isInState(1)) {
            this.performConditionalSelection();
        }
        if (button != 1) {
            this.setState(8);
            if (button == 3) {
                this.setState(0x40000000);
            }
            this.handleInvalidInput();
        } else {
            this.stateTransition(1, 2);
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(2)) {
            this.performSelection();
            this.setState(0x40000000);
            return true;
        }
        return false;
    }

    protected boolean handleDoubleClick(int button) {
        this.getSourceEditPart().performRequest(new Request("direct edit"));
        return true;
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected boolean hasSelectionOccurred() {
        return this.getFlag(64);
    }

    protected void performConditionalSelection() {
        if (this.getSourceEditPart().getSelected() == 0) {
            this.performSelection();
        }
    }

    protected void performSelection() {
        if (this.hasSelectionOccurred()) {
            return;
        }
        this.setFlag(64, true);
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedObjects = viewer.getSelectedEditParts();
        if (this.getCurrentInput().isControlKeyDown()) {
            if (selectedObjects.contains(this.getSourceEditPart())) {
                viewer.deselect(this.getSourceEditPart());
            } else {
                viewer.appendSelection(this.getSourceEditPart());
            }
        } else if (this.getCurrentInput().isShiftKeyDown()) {
            viewer.appendSelection(this.getSourceEditPart());
        } else {
            viewer.select(this.getSourceEditPart());
        }
    }

    protected void resetFlags() {
        super.resetFlags();
        this.setFlag(64, false);
    }

    protected void setSourceEditPart(EditPart part) {
        this.editpart = part;
    }
}

