/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.graphics.Cursor;

public class ResizeTracker
extends SimpleDragTracker {
    private int direction;

    public ResizeTracker(int direction) {
        this.direction = direction;
    }

    protected List createOperationSet() {
        List list = super.createOperationSet();
        ToolUtilities.filterEditPartsUnderstanding(list, this.getSourceRequest());
        return list;
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest("resize");
        request.setResizeDirection(this.getResizeDirection());
        return request;
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Resize Handle Tracker");
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            command.add(part.getCommand(this.getSourceRequest()));
            ++i;
        }
        return command.unwrap();
    }

    protected String getCommandName() {
        return "resize";
    }

    protected Cursor getDefaultCursor() {
        return Cursors.getDirectionalCursor((int)this.direction);
    }

    protected String getDebugName() {
        return "Resize Handle Tracker";
    }

    protected int getResizeDirection() {
        return this.direction;
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point corner = new Point(0, 0);
        Dimension resize = new Dimension(0, 0);
        if ((this.getResizeDirection() & 1) != 0) {
            corner.y += d.height;
            resize.height -= d.height;
        }
        if ((this.getResizeDirection() & 4) != 0) {
            resize.height += d.height;
        }
        if ((this.getResizeDirection() & 8) != 0) {
            corner.x += d.width;
            resize.width -= d.width;
        }
        if ((this.getResizeDirection() & 0x10) != 0) {
            resize.width += d.width;
        }
        request.setMoveDelta(corner);
        request.setSizeDelta(resize);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
    }
}

