/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class MarqueeSelectionTool
extends AbstractTool {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private int mode;
    private Shape marqueeRectangleFigure;
    private List allChildren = new ArrayList();
    private List selectedEditParts;
    private Request targetRequest;
    private static final Request MARQUEE_REQUEST = new Request("selection");

    public MarqueeSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
    }

    private List calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        List children = this.getAllChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            IFigure figure = ((GraphicalEditPart)child).getFigure();
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            if (this.getMarqueeSelectionRectangle().contains(r.getTopLeft()) && this.getMarqueeSelectionRectangle().contains(r.getBottomRight()) && figure.isVisible() && child.getTargetEditPart(MARQUEE_REQUEST) == child) {
                newSelections.add(child);
            }
            ++i;
        }
        return newSelections;
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren = new ArrayList();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private List getAllChildren(EditPart editPart, List allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            allChildren.add(child);
            this.getAllChildren(child, allChildren);
            ++i;
        }
        return allChildren;
    }

    private List getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.allChildren = this.getAllChildren(this.getCurrentViewer().getRootEditPart(), new ArrayList());
        }
        return this.allChildren;
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Marquee Tool";
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure.setFill(false);
            this.marqueeRectangleFigure.setLineStyle(4);
            this.marqueeRectangleFigure.setForegroundColor(ColorConstants.white);
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isControlKeyDown()) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    private void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(Cursors.CROSS);
        } else {
            this.setDefaultCursor(Cursors.NO);
        }
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    private void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = (EditPart)this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }
}

