/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Cursor;

public class DragTreeItemsTracker
extends SelectEditPartTracker {
    private Request sourceCommandRequest;

    public DragTreeItemsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.setDefaultCursor(SharedCursors.CURSOR_TREE_MOVE);
        this.setDisabledCursor(Cursors.NO);
    }

    protected Cursor calculateCursor() {
        if (this.isInState(3)) {
            return null;
        }
        return super.calculateCursor();
    }

    protected Request createTargetRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest("move");
        request.setEditParts(this.getCurrentViewer().getSelectedEditParts());
        return request;
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Drag Tree Tracker");
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        request.setType(this.isMove() ? "move" : "orphan");
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            command.add(editPart.getCommand(request));
        }
        if (!this.isMove()) {
            request.setType("add children");
            if (this.getTargetEditPart() == null) {
                command.add(UnexecutableCommand.INSTANCE);
            } else {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
            }
        }
        return command;
    }

    protected String getCommandName() {
        if (this.isMove()) {
            return "move";
        }
        return "add children";
    }

    protected String getDebugName() {
        return "Tree Tracker: " + this.getCommandName();
    }

    protected Collection getExclusionSet() {
        List operationSet = this.getOperationSet();
        ArrayList result = new ArrayList(operationSet);
        result.addAll(this.includeChildren(operationSet));
        return result;
    }

    protected boolean handleButtonUp(int button) {
        super.handleButtonUp(button);
        this.executeCurrentCommand();
        return true;
    }

    protected boolean handleDragInProgress() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.showTargetFeedback();
        this.setCurrentCommand(this.getCommand());
        return true;
    }

    protected List includeChildren(List list) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            List children = ((EditPart)list.get(i)).getChildren();
            result.addAll(children);
            result.addAll(this.includeChildren(children));
            ++i;
        }
        return result;
    }

    protected boolean isMove() {
        return this.getSourceEditPart().getParent() == this.getTargetEditPart();
    }

    protected void performSelection() {
    }

    protected void updateTargetRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setLocation(this.getLocation());
        request.setType(this.getCommandName());
    }
}

