/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.events.KeyEvent;

public class DragEditPartsTracker
extends SelectEditPartTracker {
    private static final int FLAG_SOURCE_FEEDBACK = 128;
    protected static final int MAX_FLAG = 128;
    private Request sourceRequest;
    private List operationSet;
    private List exclusionSet;

    public DragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.setDisabledCursor(Cursors.NO);
    }

    public void commitDrag() {
        this.eraseSourceFeedback();
        this.eraseTargetFeedback();
        this.performDrag();
        this.setState(0x40000000);
    }

    protected List createOperationSet() {
        List list = ToolUtilities.getSelectionWithoutDependants(this.getCurrentViewer());
        ToolUtilities.filterEditPartsUnderstanding(list, this.getTargetRequest());
        return list;
    }

    protected Request createTargetRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest("move");
        return request;
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        super.deactivate();
        this.operationSet = null;
        this.exclusionSet = null;
    }

    protected void eraseSourceFeedback() {
        if (!this.getFlag(128)) {
            return;
        }
        this.setFlag(128, false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.eraseSourceFeedback(this.getTargetRequest());
            ++i;
        }
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Drag Object Tracker");
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        request.setType(this.isMove() ? "move" : "orphan");
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            command.add(editPart.getCommand(request));
        }
        if (!this.isMove()) {
            request.setType("add children");
            if (this.getTargetEditPart() == null) {
                command.add(UnexecutableCommand.INSTANCE);
            } else {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
            }
        }
        return command;
    }

    protected String getCommandName() {
        if (this.isMove()) {
            return "move";
        }
        return "add children";
    }

    protected String getDebugName() {
        return "DragEditPartsTracker:" + this.getCommandName();
    }

    protected Collection getExclusionSet() {
        if (this.exclusionSet == null) {
            List set = this.getOperationSet();
            this.exclusionSet = new ArrayList(set.size() + 1);
            int i = 0;
            while (i < set.size()) {
                GraphicalEditPart editpart = (GraphicalEditPart)set.get(i);
                this.exclusionSet.add(editpart.getFigure());
                ++i;
            }
            LayerManager layerManager = (LayerManager)this.getCurrentViewer().getEditPartRegistry().get(LayerManager.ID);
            this.exclusionSet.add(layerManager.getLayer("Connection Layer"));
        }
        return this.exclusionSet;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.performDrag();
            return true;
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleDragInProgress() {
        if (this.isInDragInProgress()) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showTargetFeedback();
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            this.accStepIncrement();
            if (this.stateTransition(1, 32)) {
                this.setStartLocation(this.getLocation());
            }
            switch (e.keyCode) {
                case 0x1000002: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(0, this.accGetStep()));
                    break;
                }
                case 0x1000001: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(0, -this.accGetStep()));
                    break;
                }
                case 0x1000004: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(this.accGetStep(), 0));
                    break;
                }
                case 0x1000003: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(-this.accGetStep(), 0));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            this.accStepReset();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        super.handleInvalidInput();
        this.eraseSourceFeedback();
        return true;
    }

    protected boolean isMove() {
        return this.getSourceEditPart().getParent() == this.getTargetEditPart();
    }

    protected void performDrag() {
        this.executeCurrentCommand();
    }

    protected void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getTargetRequest());
            ++i;
        }
        this.setFlag(128, true);
    }

    protected void updateTargetRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        Dimension d = this.getDragMoveDelta();
        request.setMoveDelta(new Point(d.width, d.height));
        request.setLocation(this.getLocation());
        request.setType(this.getCommandName());
    }
}

