/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.graphics.Cursor;

public class AbstractConnectionCreationTool
extends TargetingTool {
    protected static final int STATE_CONNECTION_STARTED = 64;
    protected static final int MAX_STATE = 64;
    private static final int FLAG_SOURCE_FEEDBACK = 64;
    protected static final int MAX_FLAG = 64;
    private Command command;
    private EditPart connectionSource;
    private Request sourceRequest;
    private CreateRequest.Factory factory;

    public AbstractConnectionCreationTool() {
        this.setDefaultCursor(SharedCursors.CURSOR_PLUG);
        this.setDisabledCursor(Cursors.NO);
    }

    public AbstractConnectionCreationTool(CreateRequest.Factory factory) {
        this();
        this.setFactory(factory);
    }

    protected Cursor calculateCursor() {
        if (this.isInState(1) && this.getCurrentCommand() != null) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    protected Request createTargetRequest() {
        CreateConnectionRequest req = new CreateConnectionRequest();
        req.setFactory(this.getFactory());
        return req;
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        super.deactivate();
        this.setState(0x40000000);
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingSourceFeedback()) {
            return;
        }
        this.setFlag(64, false);
        if (this.connectionSource != null) {
            this.connectionSource.eraseSourceFeedback(this.getSourceRequest());
        }
    }

    protected String getCommandName() {
        if (this.isInState(64)) {
            return "connection end";
        }
        return "connection start";
    }

    protected String getDebugName() {
        return "Connection Creation Tool";
    }

    protected String getDebugNameForState(int s) {
        if (s == 64) {
            return "Connection Started";
        }
        return super.getDebugNameForState(s);
    }

    protected CreateRequest.Factory getFactory() {
        return this.factory;
    }

    protected Request getSourceRequest() {
        return this.getTargetRequest();
    }

    protected boolean handleButtonDown(int button) {
        if (this.isInState(1) && button == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.connectionSource = this.getTargetEditPart();
            this.command = this.getCommand();
            ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
            if (this.command != null) {
                this.setState(64);
                this.setCurrentCommand(this.command);
            }
        }
        if (this.isInState(1) && button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleCreateConnection() {
        this.eraseSourceFeedback();
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.executeCurrentCommand();
        return true;
    }

    protected boolean handleDrag() {
        if (this.isInState(64)) {
            return this.handleMove();
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseSourceFeedback();
        return super.handleInvalidInput();
    }

    protected boolean handleMove() {
        if (this.isInState(65)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean isShowingSourceFeedback() {
        return this.getFlag(64);
    }

    public void setFactory(CreateRequest.Factory factory) {
        this.factory = factory;
    }

    protected void showSourceFeedback() {
        if (this.connectionSource != null) {
            this.connectionSource.showSourceFeedback(this.getSourceRequest());
        }
        this.setFlag(64, true);
    }

    protected void updateTargetRequest() {
        CreateConnectionRequest request = (CreateConnectionRequest)this.getTargetRequest();
        request.setType(this.getCommandName());
        request.setLocation(this.getLocation());
    }
}

