/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.requests;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;

public class CreateRequest
extends Request
implements DropRequest {
    private Object newObject;
    private Dimension size;
    private Point location;
    private Factory creationFactory;

    public CreateRequest() {
        this.setType("create child");
    }

    public CreateRequest(Object type) {
        this.setType(type);
    }

    protected Factory getFactory() {
        return this.creationFactory;
    }

    public Point getLocation() {
        return this.location;
    }

    public Object getNewObject() {
        if (this.newObject == null) {
            this.newObject = this.getFactory().getNewObject();
        }
        return this.newObject;
    }

    public Object getNewObjectType() {
        return this.getFactory().getObjectType();
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setFactory(Factory factory) {
        this.creationFactory = factory;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public interface Factory {
        public Object getNewObject();

        public Object getObjectType();
    }

    public static final class SimpleFactory
    implements Factory {
        private Class type;

        public SimpleFactory(Class aClass) {
            this.type = aClass;
        }

        public Object getNewObject() {
            try {
                return this.type.newInstance();
            }
            catch (Exception exc) {
                return null;
            }
        }

        public Object getObjectType() {
            return this.type;
        }
    }
}

