/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.requests;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class AlignmentRequest
extends ChangeBoundsRequest {
    private Rectangle alignmentRect;
    private int alignment;

    public AlignmentRequest() {
    }

    public AlignmentRequest(Object type) {
        super(type);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Rectangle getAlignmentRectangle() {
        return this.alignmentRect;
    }

    public Rectangle getTransformedRectangle(Rectangle rect) {
        if (this.getAlignmentRectangle() == null) {
            return rect;
        }
        Rectangle changed = new Rectangle(rect);
        switch (this.alignment) {
            case 1: {
                changed.x = this.getAlignmentRectangle().x;
                break;
            }
            case 4: {
                changed.x = this.getAlignmentRectangle().x + this.getAlignmentRectangle().width - changed.width;
                break;
            }
            case 8: {
                changed.y = this.getAlignmentRectangle().y;
                break;
            }
            case 32: {
                changed.y = this.getAlignmentRectangle().y + this.getAlignmentRectangle().height - changed.height;
                break;
            }
            case 2: {
                changed.x = this.getAlignmentRectangle().x + this.getAlignmentRectangle().width / 2 - changed.width / 2;
                break;
            }
            case 16: {
                changed.y = this.getAlignmentRectangle().y + this.getAlignmentRectangle().height / 2 - changed.height / 2;
            }
        }
        return changed;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public void setAlignmentRectangle(Rectangle rect) {
        this.alignmentRect = rect;
    }
}

