/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.properties;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.ForwardUndoCompoundCommand;
import org.eclipse.gef.internal.ui.properties.RestoreDefaultPropertyValueCommand;
import org.eclipse.gef.internal.ui.properties.SetPropertyValueCommand;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class UndoablePropertySheetEntry
implements IPropertySheetEntry {
    private CommandStackListener commandStackListener;
    protected CommandStack stack;
    private Object[] values = new Object[0];
    protected Map sources = new HashMap(0);
    private Object editValue;
    private UndoablePropertySheetEntry parent;
    private IPropertySourceProvider propertySourceProvider;
    private IPropertyDescriptor descriptor;
    private CellEditor editor;
    private String errorText;
    protected UndoablePropertySheetEntry[] childEntries = null;
    private ListenerList listeners = new ListenerList();
    private ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                UndoablePropertySheetEntry.this.setErrorText(UndoablePropertySheetEntry.this.editor.getErrorMessage());
            } else {
                UndoablePropertySheetEntry.this.setErrorText(null);
            }
        }

        public void cancelEditor() {
            UndoablePropertySheetEntry.this.setErrorText(null);
        }

        public void applyEditorValue() {
            UndoablePropertySheetEntry.this.applyEditorValue();
        }
    };
    static /* synthetic */ Class class$0;

    public UndoablePropertySheetEntry() {
    }

    public UndoablePropertySheetEntry(CommandStack stack) {
        this.setCommandStack(stack);
    }

    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void applyEditorValue() {
        if (this.editor == null || !this.editor.isValueValid()) {
            return;
        }
        Object newValue = this.editor.getValue();
        boolean changed = false;
        if (this.editValue == null) {
            if (newValue != null) {
                changed = true;
            }
        } else if (!this.editValue.equals(newValue)) {
            changed = true;
        }
        if (changed) {
            this.setValue(newValue);
        }
    }

    protected List computeMergedPropertyDescriptors() {
        if (this.values.length == 0) {
            return new ArrayList(0);
        }
        Map[] propertyDescriptorMaps = new Map[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            Object object = this.values[i];
            IPropertySource source = this.getPropertySource(object);
            if (source == null) {
                return new ArrayList(0);
            }
            propertyDescriptorMaps[i] = this.computePropertyDescriptorsFor(source);
            ++i;
        }
        Map intersection = propertyDescriptorMaps[0];
        int i2 = 1;
        while (i2 < propertyDescriptorMaps.length) {
            Object[] ids = intersection.keySet().toArray();
            int j = 0;
            while (j < ids.length) {
                Object object = propertyDescriptorMaps[i2].get(ids[j]);
                if (object == null || !((IPropertyDescriptor)intersection.get(ids[j])).isCompatibleWith((IPropertyDescriptor)object)) {
                    intersection.remove(ids[j]);
                }
                ++j;
            }
            ++i2;
        }
        ArrayList descriptors = new ArrayList(intersection.values());
        Collections.sort(descriptors, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IPropertyDescriptor d1 = (IPropertyDescriptor)a;
                String dname1 = d1.getDisplayName();
                IPropertyDescriptor d2 = (IPropertyDescriptor)b;
                String dname2 = d2.getDisplayName();
                return this.coll.compare(dname1, dname2);
            }
        });
        return descriptors;
    }

    private Map computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        int i = 0;
        while (i < descriptors.length) {
            result.put(descriptors[i].getId(), descriptors[i]);
            ++i;
        }
        return result;
    }

    private void createChildEntries() {
        List descriptors = this.computeMergedPropertyDescriptors();
        this.childEntries = this.createChildEntries(descriptors.size());
        int i = 0;
        while (i < descriptors.size()) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i);
            UndoablePropertySheetEntry entry = this.createChildEntry();
            entry.setDescriptor(d);
            entry.setParent(this);
            entry.setPropertySourceProvider(this.propertySourceProvider);
            entry.refreshValues();
            this.childEntries[i] = entry;
            ++i;
        }
    }

    protected UndoablePropertySheetEntry createChildEntry() {
        return new UndoablePropertySheetEntry();
    }

    public void dispose() {
        if (this.stack != null) {
            this.stack.removeCommandStackListener(this.commandStackListener);
        }
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].dispose();
                ++i;
            }
        }
    }

    private void fireChildEntriesChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.childEntriesChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    private void fireErrorMessageChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.errorMessageChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    private void fireValueChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.valueChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    public String getCategory() {
        return this.descriptor.getCategory();
    }

    public IPropertySheetEntry[] getChildEntries() {
        if (this.childEntries == null) {
            this.createChildEntries();
        }
        return this.childEntries;
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    private IPropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public CellEditor getEditor(Composite parent) {
        if (this.editor == null) {
            this.editor = this.descriptor.createPropertyEditor(parent);
            if (this.editor != null) {
                this.editor.addListener(this.cellEditorListener);
            }
        }
        if (this.editor != null) {
            this.editor.setValue(this.editValue);
            this.setErrorText(this.editor.getErrorMessage());
        }
        return this.editor;
    }

    private Object getEditValue() {
        return this.editValue;
    }

    protected Object getEditValue(int index) {
        Object value = this.values[index];
        IPropertySource source = this.getPropertySource(value);
        if (source != null) {
            value = source.getEditableValue();
        }
        return value;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String[] getFilters() {
        return this.descriptor.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this.descriptor.getHelpContextIds();
    }

    public Image getImage() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return null;
        }
        return provider.getImage(this.editValue);
    }

    protected UndoablePropertySheetEntry getParent() {
        return this.parent;
    }

    private IPropertySource getPropertySource(Object object) {
        if (this.sources.containsKey(object)) {
            return (IPropertySource)this.sources.get(object);
        }
        IPropertySource result = null;
        if (this.propertySourceProvider != null) {
            result = this.propertySourceProvider.getPropertySource(object);
        } else if (object instanceof IPropertySource) {
            result = (IPropertySource)object;
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (IPropertySource)iAdaptable.getAdapter((Class)clazz);
        }
        this.sources.put(object, result);
        return result;
    }

    public String getValueAsString() {
        if (this.editValue == null) {
            return "";
        }
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            String editToString = this.editValue.toString();
            if (editToString == null) {
                return "EDIT VALUE TO STRING NULL";
            }
            return editToString;
        }
        String providerText = provider.getText(this.editValue);
        if (providerText == null) {
            return provider.toString();
        }
        return providerText;
    }

    private Object[] getValues() {
        return this.values;
    }

    public boolean hasChildEntries() {
        if (this.childEntries != null && this.childEntries.length > 0) {
            return true;
        }
        return this.computeMergedPropertyDescriptors().size() > 0;
    }

    private void refreshChildEntries() {
        if (this.childEntries == null) {
            return;
        }
        List descriptors = this.computeMergedPropertyDescriptors();
        HashMap<Object, UndoablePropertySheetEntry> entryCache = new HashMap<Object, UndoablePropertySheetEntry>(this.childEntries.length * 2 + 1);
        int i = 0;
        while (i < this.childEntries.length) {
            entryCache.put(this.childEntries[i].getDescriptor().getId(), this.childEntries[i]);
            ++i;
        }
        ArrayList<UndoablePropertySheetEntry> entriesToDispose = new ArrayList<UndoablePropertySheetEntry>(Arrays.asList(this.childEntries));
        this.childEntries = this.createChildEntries(descriptors.size());
        boolean entriesChanged = descriptors.size() != entryCache.size();
        int i2 = 0;
        while (i2 < descriptors.size()) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i2);
            UndoablePropertySheetEntry entry = (UndoablePropertySheetEntry)entryCache.get(d.getId());
            if (entry != null) {
                entry.setDescriptor(d);
                entriesToDispose.remove(entry);
            } else {
                entry = this.createChildEntry();
                entry.setDescriptor(d);
                entry.setParent(this);
                entry.setPropertySourceProvider(this.propertySourceProvider);
                entriesChanged = true;
            }
            entry.refreshValues();
            this.childEntries[i2] = entry;
            ++i2;
        }
        if (entriesChanged) {
            this.fireChildEntriesChanged();
        }
        i2 = 0;
        while (i2 < entriesToDispose.size()) {
            ((IPropertySheetEntry)entriesToDispose.get(i2)).dispose();
            ++i2;
        }
    }

    protected UndoablePropertySheetEntry[] createChildEntries(int size) {
        return new UndoablePropertySheetEntry[size];
    }

    private void refreshFromRoot() {
        if (this.parent == null) {
            this.refreshChildEntries();
        } else {
            this.parent.refreshFromRoot();
        }
    }

    protected void refreshValues() {
        Object[] sources = this.parent.getValues();
        Object[] newValues = new Object[sources.length];
        int i = 0;
        while (i < sources.length) {
            IPropertySource source = this.parent.getPropertySource(sources[i]);
            newValues[i] = source.getPropertyValue(this.descriptor.getId());
            ++i;
        }
        this.setValues(newValues);
    }

    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void resetPropertyValue() {
        CompoundCommand cc = new CompoundCommand();
        if (this.parent == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.parent.getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.descriptor.getId())) {
                RestoreDefaultPropertyValueCommand restoreCmd = new RestoreDefaultPropertyValueCommand();
                restoreCmd.setTarget(source);
                restoreCmd.setPropertyId(this.descriptor.getId());
                restoreCmd.setPropertyValue(source.getPropertyValue(this.descriptor.getId()));
                cc.add(restoreCmd);
                change = true;
            }
            ++i;
        }
        if (change) {
            this.stack.execute(cc);
            this.refreshValues();
        }
    }

    public void setCommandStack(CommandStack stack) {
        this.stack = stack;
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject e) {
                UndoablePropertySheetEntry.this.refreshFromRoot();
            }
        };
        stack.addCommandStackListener(this.commandStackListener);
    }

    protected void setDescriptor(IPropertyDescriptor newDescriptor) {
        if (this.descriptor != newDescriptor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        this.descriptor = newDescriptor;
    }

    private void setErrorText(String newErrorText) {
        this.errorText = newErrorText;
        this.fireErrorMessageChanged();
    }

    protected void setParent(UndoablePropertySheetEntry p) {
        this.parent = p;
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    private void setValue(Object newValue) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = newValue;
            ++i;
        }
        this.parent.valueChanged(this, new ForwardUndoCompoundCommand());
        this.refreshFromRoot();
    }

    public void setValues(Object[] objects) {
        this.values = objects;
        this.sources = new HashMap(this.values.length * 2 + 1);
        if (this.values.length == 0) {
            this.editValue = null;
        } else {
            Object newValue = this.values[0];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null) {
                newValue = source.getEditableValue();
            }
            this.editValue = newValue;
        }
        this.refreshChildEntries();
        this.fireValueChanged();
    }

    protected void valueChanged(UndoablePropertySheetEntry child, CompoundCommand command) {
        CompoundCommand cc = new CompoundCommand();
        command.add(cc);
        int i = 0;
        while (i < this.values.length) {
            SetPropertyValueCommand setCommand = new SetPropertyValueCommand();
            setCommand.setTarget(this.getPropertySource(this.values[i]));
            setCommand.setPropertyId(child.getDescriptor().getId());
            setCommand.setPropertyValue(child.getEditValue(i));
            cc.add(setCommand);
            ++i;
        }
        if (this.parent != null) {
            this.parent.valueChanged(this, command);
        } else {
            this.stack.execute(command);
        }
    }
}

