/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.properties;

import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.ui.views.properties.IPropertySource;

public class RestoreDefaultPropertyValueCommand
extends AbstractCommand {
    protected Object propertyValue;
    protected Object propertyName;
    protected Object undoValue;
    protected boolean resetOnUndo;
    protected IPropertySource target;

    public RestoreDefaultPropertyValueCommand() {
        super("Restore Default Property Value");
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.resetOnUndo = this.getTarget().isPropertySet(this.propertyName);
        if (this.resetOnUndo) {
            this.undoValue = this.getTarget().getPropertyValue(this.propertyName);
            this.getTarget().resetPropertyValue(this.propertyName);
        } else {
            this.undoValue = null;
        }
    }

    public IPropertySource getTarget() {
        return this.target;
    }

    public void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
    }

    public void redo() {
        this.execute();
    }

    public void setPropertyId(Object pName) {
        this.propertyName = pName;
    }

    public void setPropertyValue(Object val) {
        this.propertyValue = val;
    }

    public void undo() {
        if (this.resetOnUndo) {
            this.getTarget().setPropertyValue(this.propertyName, this.undoValue);
        } else {
            this.getTarget().resetPropertyValue(this.propertyName);
        }
    }
}

