/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.resources;

import java.lang.ref.WeakReference;

public abstract class ResourceRecord {
    Object key;
    Finalizer finalizer = null;
    WeakReference reference;
    int users;

    public void decrementUsers() {
        --this.users;
        if (this.users == 0) {
            this.finalizer = null;
        }
    }

    public void incrementUsers() {
        if (this.users == 0 && this.reference != null) {
            this.finalizer = (Finalizer)this.reference.get();
        }
        ++this.users;
    }

    abstract void dispose(Object var1);

    protected Object getResource() {
        if (this.reference == null || this.reference.get() == null) {
            this.recreate();
        }
        return this.finalizer.getResource();
    }

    abstract void recreate();

    protected void setFinalizer(Finalizer f) {
        this.finalizer = f;
        this.reference = new WeakReference<Finalizer>(f);
    }

    protected class Finalizer {
        Object resource;

        public Finalizer(Object resource) {
            this.resource = resource;
        }

        protected void finalize() {
            ResourceRecord.this.dispose(this.resource);
        }

        protected Object getResource() {
            return this.resource;
        }
    }
}

