/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.handles;

import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ResizableHandleKit {
    protected static final Cursor NORTH_CURSOR = new Cursor((Device)Display.getDefault(), 10);
    protected static final Cursor SOUTH_CURSOR = new Cursor((Device)Display.getDefault(), 11);
    protected static final Cursor EAST_CURSOR = new Cursor((Device)Display.getDefault(), 12);
    protected static final Cursor WEST_CURSOR = new Cursor((Device)Display.getDefault(), 13);
    protected static final Cursor NORTHEAST_CURSOR = new Cursor((Device)Display.getDefault(), 14);
    protected static final Cursor NORTHWEST_CURSOR = new Cursor((Device)Display.getDefault(), 17);
    protected static final Cursor SOUTHEAST_CURSOR = new Cursor((Device)Display.getDefault(), 15);
    protected static final Cursor SOUTHWEST_CURSOR = new Cursor((Device)Display.getDefault(), 16);

    public static void addHandles(GraphicalEditPart part, List handles) {
        ResizableHandleKit.addMoveHandle(part, handles);
        handles.add(ResizableHandleKit.createHandle(part, 16));
        handles.add(ResizableHandleKit.createHandle(part, 20));
        handles.add(ResizableHandleKit.createHandle(part, 4));
        handles.add(ResizableHandleKit.createHandle(part, 12));
        handles.add(ResizableHandleKit.createHandle(part, 8));
        handles.add(ResizableHandleKit.createHandle(part, 9));
        handles.add(ResizableHandleKit.createHandle(part, 1));
        handles.add(ResizableHandleKit.createHandle(part, 17));
    }

    public static void addMoveHandle(GraphicalEditPart f, List handles) {
        handles.add(ResizableHandleKit.moveHandle(f));
    }

    static Handle createHandle(GraphicalEditPart owner, int direction) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        handle.setDragTracker(new ResizeTracker(direction));
        return handle;
    }

    public static Handle moveHandle(GraphicalEditPart owner) {
        return new MoveHandle(owner);
    }
}

