/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public abstract class XYLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    protected static final Dimension DEFAULT_SIZE = new Dimension(-1, -1);

    public Object getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    public Object getConstraintFor(Point p) {
        return new Rectangle(p, DEFAULT_SIZE);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle rect = child.getFigure().getBounds().getCopy();
        rect = request.getTransformedRectangle(rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        if ("move children".equals(request.getType())) {
            Rectangle cons = this.getCurrentConstraintFor(child);
            rect.setSize(cons.width, cons.height);
        }
        if ("resize children".equals(request.getType())) {
            Dimension minSize = this.getMinimumSizeFor(child);
            if (rect.width < minSize.width) {
                rect.width = minSize.width;
            }
            if (rect.height < minSize.height) {
                rect.height = minSize.height;
            }
        }
        return this.getConstraintFor(rect);
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        return (Rectangle)fig.getParent().getLayoutManager().getConstraint(fig);
    }

    public Object getDefaultConstraint() {
        return new Rectangle(new Point(10, 10), DEFAULT_SIZE);
    }

    protected Point getLayoutOrigin() {
        IFigure container = this.getLayoutContainer();
        XYLayout layout = (XYLayout)container.getLayoutManager();
        return layout.getOrigin(container);
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart part) {
        return new Dimension(8, 8);
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
        Point p = new Point(request.getLocation());
        IFigure feedback = this.getSizeOnDropFeedback();
        feedback.translateToRelative((Translatable)p);
        feedback.setBounds(new Rectangle(p, request.getSize()));
    }
}

