/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ResizableEditPolicy
extends NonResizableEditPolicy {
    protected List createSelectionHandles() {
        ArrayList list = new ArrayList();
        ResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
        return list;
    }

    public void eraseSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    public Command getCommand(Request request) {
        if ("resize".equals(request.getType())) {
            return this.getResizeCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest("resize children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand(req);
    }

    public void showSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    public boolean understandsRequest(Request request) {
        if ("resize".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }
}

