/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class NonResizableEditPolicy
extends SelectionHandlesEditPolicy {
    private IFigure focusRect;
    private IFigure feedback;
    private boolean useRealtimeFeedback = false;
    private Rectangle originalLocation;

    protected IFigure createDragSourceFeedbackFigure() {
        if (this.useRealtimeFeedback) {
            return ((GraphicalEditPart)this.getHost()).getFigure();
        }
        RectangleFigure r = new RectangleFigure();
        FigureUtilities.makeGhostShape((Shape)r);
        r.setLineStyle(4);
        r.setForegroundColor(ColorConstants.white);
        r.setBounds(this.getBounds());
        this.addFeedback((IFigure)r);
        return r;
    }

    protected List createSelectionHandles() {
        ArrayList list = new ArrayList();
        NonResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
        return list;
    }

    public void deactivate() {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
            this.feedback = null;
        }
        this.hideFocus();
        super.deactivate();
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.feedback != null) {
            if (this.useRealtimeFeedback) {
                this.feedback.setBounds(this.originalLocation);
                this.feedback.revalidate();
            } else {
                this.removeFeedback(this.feedback);
            }
        }
        this.feedback = null;
        this.originalLocation = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    private Rectangle getBounds() {
        return ((GraphicalEditPart)this.getHost()).getFigure().getBounds();
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("move".equals(type)) {
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        if ("orphan".equals(type)) {
            return this.getOrphanCommand(request);
        }
        if ("align".equals(type)) {
            return this.getAlignCommand((AlignmentRequest)request);
        }
        return null;
    }

    protected IFigure getDragSourceFeedbackFigure() {
        if (this.feedback == null) {
            IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
            this.originalLocation = new Rectangle(fig.getBounds());
            this.feedback = this.createDragSourceFeedbackFigure();
        }
        return this.feedback;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        AlignmentRequest req = new AlignmentRequest("align children");
        req.setEditParts(this.getHost());
        req.setAlignment(request.getAlignment());
        req.setAlignmentRectangle(request.getAlignmentRectangle());
        return this.getHost().getParent().getCommand(req);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest("move children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        return this.getHost().getParent().getCommand(req);
    }

    protected Command getOrphanCommand(Request req) {
        return null;
    }

    protected void hideFocus() {
        if (this.focusRect != null) {
            this.removeFeedback(this.focusRect);
        }
        this.focusRect = null;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure p = this.getDragSourceFeedbackFigure();
        Rectangle r = this.originalLocation.getTranslated(request.getMoveDelta());
        Dimension resize = request.getSizeDelta();
        r.width += resize.width;
        r.height += resize.height;
        ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)r);
        p.translateToRelative((Translatable)r);
        p.setBounds(r);
        if (this.useRealtimeFeedback) {
            p.validate();
        }
    }

    protected void showFocus() {
        this.focusRect = new AbstractHandle((GraphicalEditPart)this.getHost(), new Locator(){

            public void relocate(IFigure target) {
                Rectangle r = NonResizableEditPolicy.this.getHostFigure().getBounds().getCopy();
                NonResizableEditPolicy.this.getHostFigure().translateToAbsolute((Translatable)r);
                target.translateToRelative((Translatable)r);
                target.setBounds(r.expand(5, 5));
            }
        }){
            {
                this.setBorder((Border)new FocusBorder());
            }

            protected DragTracker createDragTracker() {
                return null;
            }
        };
        this.addFeedback(this.focusRect);
    }

    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public boolean understandsRequest(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType()) || "orphan".equals(request.getType()) || "align".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }
}

