/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.DeleteRequest;

public class NodeEditPolicy
extends AbstractEditPolicy {
    protected Command getAncestorDeletedCommand(DeleteRequest req) {
        return this.getDeleteCommand(req);
    }

    public Command getCommand(Request request) {
        if ("ancestor deleted".equals(request.getType())) {
            return this.getAncestorDeletedCommand((DeleteRequest)request);
        }
        if ("delete".equals(request.getType())) {
            return this.getDeleteCommand((DeleteRequest)request);
        }
        return null;
    }

    protected Command getDeleteCommand(DeleteRequest delRequest) {
        EditPart connection;
        CompoundCommand cc = new CompoundCommand();
        cc.setDebugLabel("delete in NodeEditPolicy");
        List connections = this.getHostNode().getSourceConnections();
        DeleteRequest fwdRequest = new DeleteRequest("source deleted");
        fwdRequest.setContributions(delRequest.getContributions());
        int i = 0;
        while (i < connections.size()) {
            connection = (EditPart)connections.get(i);
            if (!fwdRequest.containsContribution(connection)) {
                fwdRequest.addContribution(connection);
                cc.add(connection.getCommand(fwdRequest));
            }
            ++i;
        }
        connections = this.getHostNode().getTargetConnections();
        fwdRequest.setType("target deleted");
        i = 0;
        while (i < connections.size()) {
            connection = (EditPart)connections.get(i);
            if (!fwdRequest.containsContribution(connection)) {
                fwdRequest.addContribution(connection);
                cc.add(connection.getCommand(fwdRequest));
            }
            ++i;
        }
        return cc.isEmpty() ? null : cc;
    }

    private GraphicalEditPart getHostNode() {
        return (GraphicalEditPart)this.getHost();
    }
}

