/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public abstract class LayoutEditPolicy
extends GraphicalEditPolicy {
    private Shape sizeOnDropFeedback;
    private EditPartListener listener;

    public void activate() {
        this.setListener(this.createListener());
        this.decorateChildren();
        super.activate();
    }

    protected abstract EditPolicy createChildEditPolicy(EditPart var1);

    protected EditPartListener createListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart child, int index) {
                LayoutEditPolicy.this.decorateChild(child);
            }

            public void removingChild(EditPart child, int index) {
                LayoutEditPolicy.this.undecorateChild(child);
            }
        };
    }

    public void deactivate() {
        this.undecorateChildren();
        this.setListener(null);
        super.deactivate();
    }

    protected void decorateChild(EditPart child) {
        EditPolicy policy = this.createChildEditPolicy(child);
        child.installEditPolicy("PrimaryDrag Policy", policy);
    }

    protected void decorateChildren() {
        List children = this.getHost().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.decorateChild((EditPart)children.get(i));
            ++i;
        }
    }

    protected void eraseDragTargetFeedback(Request request) {
    }

    protected void eraseSizeOnDropFeedback(Request request) {
        if (this.sizeOnDropFeedback != null) {
            this.removeFeedback((IFigure)this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("add children".equals(request.getType()) || "move".equals(request.getType()) || "create child".equals(request.getType())) {
            this.eraseDragTargetFeedback(request);
        }
        if ("create child".equals(request.getType())) {
            this.eraseSizeOnDropFeedback(request);
        }
    }

    protected Command getAddCommand(Request request) {
        return null;
    }

    public Command getCommand(Request request) {
        if ("delete dependant".equals(request.getType())) {
            return this.getDeleteDependantCommand(request);
        }
        if ("add children".equals(request.getType())) {
            return this.getAddCommand(request);
        }
        if ("orphan children".equals(request.getType())) {
            return this.getOrphanChildrenCommand(request);
        }
        if ("move children".equals(request.getType())) {
            return this.getMoveChildrenCommand(request);
        }
        if ("create child".equals(request.getType())) {
            return this.getCreateCommand((CreateRequest)request);
        }
        return null;
    }

    protected abstract Command getCreateCommand(CreateRequest var1);

    protected abstract Command getDeleteDependantCommand(Request var1);

    protected IFigure getFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected IFigure getLayoutContainer() {
        return ((GraphicalEditPart)this.getHost()).getContentPane();
    }

    protected abstract Command getMoveChildrenCommand(Request var1);

    protected Command getOrphanChildrenCommand(Request request) {
        return null;
    }

    protected IFigure getSizeOnDropFeedback() {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)this.sizeOnDropFeedback);
            this.sizeOnDropFeedback.setLineStyle(4);
            this.sizeOnDropFeedback.setForegroundColor(ColorConstants.white);
            this.addFeedback((IFigure)this.sizeOnDropFeedback);
        }
        return this.sizeOnDropFeedback;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("add children".equals(request.getType()) || "move".equals(request.getType()) || "create child".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected void setListener(EditPartListener listener) {
        if (this.listener != null) {
            this.getHost().removeEditPartListener(this.listener);
        }
        this.listener = listener;
        if (this.listener != null) {
            this.getHost().addEditPartListener(this.listener);
        }
    }

    protected void showDragTargetFeedback(Request request) {
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
    }

    public void showTargetFeedback(Request request) {
        CreateRequest createReq;
        if ("add children".equals(request.getType()) || "move".equals(request.getType()) || "resize children".equals(request.getType()) || "create child".equals(request.getType())) {
            this.debugFeedback("Request to show \"" + request.getType() + "\" target feedback");
            this.showDragTargetFeedback(request);
        }
        if ("create child".equals(request.getType()) && (createReq = (CreateRequest)request).getSize() != null) {
            this.showSizeOnDropFeedback(createReq);
        }
    }

    protected void undecorateChild(EditPart child) {
        child.removeEditPolicy("PrimaryDrag Policy");
    }

    protected void undecorateChildren() {
        List children = this.getHost().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.undecorateChild((EditPart)children.get(i));
            ++i;
        }
    }
}

