/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class GraphicalNodeEditPolicy
extends GraphicalEditPolicy {
    protected FeedbackHelper feedbackHelper;
    protected Connection connectionFeedback;

    protected Connection createDummyConnection(Request req) {
        return new PolylineConnection();
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        if (this.connectionFeedback != null) {
            this.removeFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper = null;
            this.connectionFeedback = null;
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("connection end".equals(request.getType())) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
            this.debugFeedback("Request to erase \"" + request.getType() + "\" source feedback");
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
    }

    public void eraseTargetFeedback(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.eraseTargetConnectionFeedback((DropRequest)((Object)request));
            this.debugFeedback("Request to erase \"" + request.getType() + "\" target feedback");
        }
    }

    public Command getCommand(Request request) {
        if ("connection start".equals(request.getType())) {
            return this.getConnectionCreateCommand((CreateConnectionRequest)request);
        }
        if ("connection end".equals(request.getType())) {
            return this.getConnectionCompleteCommand((CreateConnectionRequest)request);
        }
        if ("Reconnection target".equals(request.getType())) {
            return this.getReconnectTargetCommand((ReconnectRequest)request);
        }
        if ("Reconnection source".equals(request.getType())) {
            return this.getReconnectSourceCommand((ReconnectRequest)request);
        }
        return null;
    }

    protected abstract Command getConnectionCompleteCommand(CreateConnectionRequest var1);

    protected abstract Command getConnectionCreateCommand(CreateConnectionRequest var1);

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            Point p = request.getLocation();
            this.connectionFeedback = this.createDummyConnection(request);
            ConnectionLayer layer = (ConnectionLayer)this.getLayer("Connection Layer");
            this.connectionFeedback.setConnectionRouter(layer.getConnectionRouter());
            this.connectionFeedback.setSourceAnchor(this.getSourceConnectionAnchor(request));
            this.feedbackHelper.setConnection(this.connectionFeedback);
            this.addFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper.update(null, p);
        }
        return this.feedbackHelper;
    }

    protected abstract Command getReconnectTargetCommand(ReconnectRequest var1);

    protected abstract Command getReconnectSourceCommand(ReconnectRequest var1);

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        EditPart source = request.getSourceEditPart();
        return source instanceof NodeEditPart ? ((NodeEditPart)source).getSourceConnectionAnchor(request) : null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        return target instanceof NodeEditPart ? ((NodeEditPart)target).getTargetConnectionAnchor(request) : null;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected void showCreationFeedback(CreateConnectionRequest request) {
        FeedbackHelper helper = this.getFeedbackHelper(request);
        Point p = new Point(request.getLocation());
        helper.update(this.getTargetConnectionAnchor(request), p);
    }

    public void showSourceFeedback(Request request) {
        if ("connection end".equals(request.getType())) {
            this.showCreationFeedback((CreateConnectionRequest)request);
            this.debugFeedback("Request to show \"" + request.getType() + "\" SOURCE feeback");
        }
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
    }

    public void showTargetFeedback(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.showTargetConnectionFeedback((DropRequest)((Object)request));
            this.debugFeedback("Request to show \"" + request.getType() + "\" TARGET feeback");
        }
    }
}

