/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.requests.DropRequest;

public abstract class FlowLayoutEditPolicy
extends OrderedLayoutEditPolicy {
    protected Polyline insertionLine;

    protected void eraseDragTargetFeedback(Request request) {
        super.eraseDragTargetFeedback(request);
        if (this.insertionLine != null) {
            this.removeFeedback((IFigure)this.insertionLine);
            this.insertionLine = null;
        }
    }

    protected Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected EditPart getInsertionReference(Request request) {
        List children = this.getHost().getChildren();
        if (request.getType().equals("create child")) {
            int i = this.getFeedbackIndexFor(request);
            if (i == -1) {
                return null;
            }
            return (EditPart)children.get(i);
        }
        int index = this.getFeedbackIndexFor(request);
        if (index != -1) {
            List selection = this.getHost().getRoot().getViewer().getSelectedEditParts();
            do {
                EditPart editpart;
                if (selection.contains(editpart = (EditPart)children.get(index))) continue;
                return editpart;
            } while (++index < children.size());
        }
        return null;
    }

    protected int getFeedbackIndexFor(Request request) {
        FlowLayout layoutManager = this.getLayoutManager();
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!layoutManager.isHorizontal());
        Point p = transposer.t(this.getLocationFromRequest(request));
        int rowBottom = Integer.MIN_VALUE;
        int candidate = -1;
        int i = 0;
        while (i < children.size()) {
            int rectBottom;
            EditPart child = (EditPart)children.get(i);
            Rectangle rect = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)child));
            if (rect.y > rowBottom) {
                if (p.y <= rowBottom) {
                    if (candidate != -1) break;
                    candidate = i;
                    break;
                }
                candidate = -1;
            }
            if ((rectBottom = rect.y + rect.height) > rowBottom) {
                rowBottom = rectBottom;
            }
            if (candidate == -1 && p.x <= rect.x + rect.width / 2) {
                candidate = i;
            }
            if (candidate != -1 && p.y <= rowBottom) break;
            ++i;
        }
        return candidate;
    }

    protected FlowLayout getLayoutManager() {
        return (FlowLayout)this.getHostFigure().getLayoutManager();
    }

    protected Polyline getLineFeedback() {
        if (this.insertionLine == null) {
            this.insertionLine = new Polyline();
            this.insertionLine.setLineWidth(2);
            this.insertionLine.addPoint(new Point(0, 0));
            this.insertionLine.addPoint(new Point(10, 10));
            this.addFeedback((IFigure)this.insertionLine);
        }
        return this.insertionLine;
    }

    protected Point getLocationFromRequest(Request request) {
        if (request instanceof DropRequest) {
            return ((DropRequest)((Object)request)).getLocation();
        }
        return null;
    }

    protected void showDragTargetFeedback(Request request) {
        Rectangle parentBox;
        EditPart editPart;
        if (this.getHost().getChildren().size() == 0) {
            return;
        }
        FlowLayout layoutManager = this.getLayoutManager();
        Polyline fb = this.getLineFeedback();
        Transposer transposer = new Transposer();
        transposer.setEnabled(!layoutManager.isHorizontal());
        boolean before = true;
        int epIndex = this.getFeedbackIndexFor(request);
        Rectangle r = null;
        if (epIndex == -1) {
            before = false;
            epIndex = this.getHost().getChildren().size() - 1;
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
        } else {
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            Point p = transposer.t(this.getLocationFromRequest(request));
            if (p.x <= r.x + r.width / 2) {
                before = true;
            } else {
                before = false;
                editPart = (EditPart)this.getHost().getChildren().get(--epIndex);
                r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            }
        }
        int x = Integer.MIN_VALUE;
        if (before) {
            if (epIndex > 0) {
                Rectangle voPrev = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost().getChildren().get(epIndex - 1)));
                int prevRight = voPrev.x + voPrev.width;
                if (prevRight < r.x) {
                    x = prevRight + (r.x - prevRight) / 2;
                } else if (prevRight == r.x) {
                    x = prevRight + 1;
                }
            }
            if (x == Integer.MIN_VALUE) {
                parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
                x = r.x - 5;
                if (x < parentBox.x) {
                    x = parentBox.x + (r.x - parentBox.x) / 2;
                }
            }
        } else {
            parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
            int rRight = r.x + r.width;
            x = rRight + 5;
            int pRight = parentBox.x + parentBox.width;
            if (x > pRight) {
                x = rRight + (pRight - rRight) / 2;
            }
        }
        Point p1 = new Point(x, r.y - 6);
        fb.translateToRelative((Translatable)p1);
        p1 = transposer.t(p1);
        Point p2 = new Point(x, r.y + r.height + 6);
        fb.translateToRelative((Translatable)p2);
        p2 = transposer.t(p2);
        fb.setPoint(p1, 0);
        fb.setPoint(p2, 1);
    }
}

