/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DeleteRequest;
import org.eclipse.gef.requests.GroupRequest;

public abstract class ContainerEditPolicy
extends AbstractEditPolicy {
    protected final void createCreateCommand(Object parent, CreateRequest.Factory factory) {
    }

    protected Command getAddCommand(GroupRequest request) {
        return null;
    }

    protected Command getAncestorDeletedCommand(DeleteRequest request) {
        return this.getDeleteCommand(request);
    }

    public Command getCommand(Request request) {
        if ("ancestor deleted".equals(request.getType())) {
            return this.getAncestorDeletedCommand((DeleteRequest)request);
        }
        if ("delete".equals(request.getType())) {
            return this.getDeleteCommand((DeleteRequest)request);
        }
        if ("delete dependant".equals(request.getType())) {
            return this.getDeleteDependantCommand(request);
        }
        if ("create child".equals(request.getType())) {
            return this.getCreateCommand((CreateRequest)request);
        }
        if ("add children".equals(request.getType())) {
            return this.getAddCommand((GroupRequest)request);
        }
        if ("orphan children".equals(request.getType())) {
            return this.getOrphanChildrenCommand((GroupRequest)request);
        }
        return null;
    }

    protected abstract Command getCreateCommand(CreateRequest var1);

    protected abstract Command getDeleteDependantCommand(Request var1);

    protected Command getDeleteCommand(DeleteRequest delete) {
        CompoundCommand compound = new CompoundCommand();
        compound.setDebugLabel("delete in ContainerEditPolicy");
        List children = this.getHost().getChildren();
        DeleteRequest ancestorDeletedReq = new DeleteRequest("ancestor deleted");
        ancestorDeletedReq.setContributions(delete.getContributions());
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            compound.add(child.getCommand(ancestorDeletedReq));
            ++i;
        }
        return compound.isEmpty() ? null : compound;
    }

    protected Command getOrphanChildrenCommand(GroupRequest request) {
        return null;
    }
}

