/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public abstract class ConstrainedLayoutEditPolicy
extends LayoutEditPolicy {
    protected abstract Command createAddCommand(EditPart var1, Object var2);

    protected abstract Command createChangeConstraintCommand(EditPart var1, Object var2);

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart childPart = (GraphicalEditPart)editParts.get(i);
            Rectangle r = childPart.getFigure().getBounds().getCopy();
            childPart.getFigure().translateToAbsolute((Translatable)r);
            r = request.getTransformedRectangle(r);
            r.translate(this.getLayoutOrigin().getNegated());
            this.getLayoutContainer().translateToRelative((Translatable)r);
            this.getLayoutContainer().translateFromParent((Translatable)r);
            Object constraint = this.getConstraintFor(r);
            command.add(this.createAddCommand(childPart, this.translateToModelConstraint(constraint)));
            ++i;
        }
        return command.unwrap();
    }

    protected Command getAlignChildrenCommand(AlignmentRequest request) {
        return this.getResizeChildrenCommand(request);
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
        }
        if ("align children".equals(request.getType())) {
            return this.getAlignChildrenCommand((AlignmentRequest)request);
        }
        return super.getCommand(request);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle rect = child.getFigure().getBounds();
        rect = request.getTransformedRectangle(rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        return this.getConstraintFor(rect);
    }

    protected abstract Object getConstraintFor(Point var1);

    protected abstract Object getConstraintFor(Rectangle var1);

    protected Object getConstraintFor(CreateRequest request) {
        IFigure figure = this.getLayoutContainer();
        Point where = request.getLocation().getCopy();
        Dimension size = request.getSize();
        figure.translateToRelative((Translatable)where);
        figure.translateFromParent((Translatable)where);
        where.translate(this.getLayoutOrigin().getNegated());
        if (size == null || size.isEmpty()) {
            return this.getConstraintFor(where);
        }
        return this.getConstraintFor(new Rectangle(where, size));
    }

    protected abstract Command getCreateCommand(CreateRequest var1);

    protected Object translateToFigureConstraint(Object modelConstraint) {
        return modelConstraint;
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        return figureConstraint;
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        List children = request.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createChangeConstraintCommand(child, this.translateToModelConstraint(this.getConstraintFor(request, child)));
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Command getMoveChildrenCommand(Request request) {
        return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
    }

    protected Point getLayoutOrigin() {
        return this.getLayoutContainer().getClientArea().getLocation();
    }
}

