/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.BendpointCreationHandle;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;

public abstract class BendpointEditPolicy
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    private static List NULL_CONSTRAINT = new ArrayList();
    private List originalConstraint;
    private Point ref1 = new Point();
    private Point ref2 = new Point();
    private boolean isDeleting = false;

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    private List createAutomaticHandles() {
        ArrayList<BendpointCreationHandle> list = new ArrayList<BendpointCreationHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 2) {
            BendpointCreationHandle handle = new BendpointCreationHandle(connEP, 0, (Locator)new BendpointLocator(this.getConnection(), i + 1));
            list.add(handle);
            ++i;
        }
        return list;
    }

    private List createManualHandles() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 2) {
            list.add(new BendpointCreationHandle(connEP, i));
            list.add(new BendpointMoveHandle(connEP, i));
            ++i;
        }
        list.add(new BendpointCreationHandle(connEP, points.size() - 2));
        return list;
    }

    protected List createSelectionHandles() {
        List list = new ArrayList();
        list = this.isAutomaticallyBending() ? this.createAutomaticHandles() : this.createManualHandles();
        return list;
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        this.restoreOriginalConstraint();
        this.originalConstraint = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "create bendpoint".equals(request.getType()) || "delete bendpoint".equals(request.getType())) {
            this.eraseConnectionFeedback((BendpointRequest)request);
        }
    }

    public Command getCommand(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            if (this.isDeleting) {
                return this.getDeleteBendpointCommand((BendpointRequest)request);
            }
            return this.getMoveBendpointCommand((BendpointRequest)request);
        }
        if ("create bendpoint".equals(request.getType())) {
            return this.getCreateBendpointCommand((BendpointRequest)request);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((ConnectionEditPart)this.getHost()).getFigure();
    }

    private Point getFirstReferencePoint() {
        return this.ref1;
    }

    private Point getSecondReferencePoint() {
        return this.ref2;
    }

    protected abstract Command getCreateBendpointCommand(BendpointRequest var1);

    protected abstract Command getDeleteBendpointCommand(BendpointRequest var1);

    protected abstract Command getMoveBendpointCommand(BendpointRequest var1);

    private boolean isAutomaticallyBending() {
        List constraint = (List)this.getConnection().getRoutingConstraint();
        PointList points = this.getConnection().getPoints();
        return points.size() > 2 && (constraint == null || constraint.isEmpty());
    }

    private boolean lineContainsPoint(Point p1, Point p2, Point p) {
        int tolerance = 7;
        Rectangle rect = Rectangle.SINGLETON;
        rect.setSize(0, 0);
        rect.setLocation(p1.x, p1.y);
        rect.union(p2.x, p2.y);
        rect.expand(tolerance, tolerance);
        if (!rect.contains(p.x, p.y)) {
            return false;
        }
        double result = 0.0;
        if (p1.x != p2.x && p1.y != p2.y) {
            int v1x = p2.x - p1.x;
            int v1y = p2.y - p1.y;
            int v2x = p.x - p1.x;
            int v2y = p.y - p1.y;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (numerator << 10) / denominator * numerator >> 10;
        }
        return result <= (double)(tolerance * tolerance);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        int points;
        int count;
        if (this.getHost().getSelected() != 0 && (count = this.handles.size()) != (points = this.getConnection().getPoints().size()) * 2 - 3) {
            this.addSelectionHandles();
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.originalConstraint != null) {
            this.getConnection().setRoutingConstraint((Object)this.originalConstraint);
        }
    }

    protected void saveOriginalConstraint() {
        this.originalConstraint = (List)this.getConnection().getRoutingConstraint();
        if (this.originalConstraint == null) {
            this.originalConstraint = NULL_CONSTRAINT;
        }
        this.getConnection().setRoutingConstraint(new ArrayList(this.originalConstraint));
    }

    private void setReferencePoints(BendpointRequest request) {
        PointList points = this.getConnection().getPoints();
        points.getPoint(this.ref1, request.getIndex());
        this.getConnection().translateToAbsolute((Translatable)this.ref1);
        points.getPoint(this.ref2, request.getIndex() + 2);
        this.getConnection().translateToAbsolute((Translatable)this.ref2);
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        List constraint;
        Point p = new Point(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.add(request.getIndex(), bp);
        } else {
            constraint = (List)this.getConnection().getRoutingConstraint();
        }
        constraint.set(request.getIndex(), bp);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    protected void showDeleteBendpointFeedback(BendpointRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            List constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.remove(request.getIndex());
            this.getConnection().setRoutingConstraint((Object)constraint);
        }
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        Point p = new Point(request.getLocation());
        if (!this.isDeleting) {
            this.setReferencePoints(request);
        }
        if (this.lineContainsPoint(this.getFirstReferencePoint(), this.getSecondReferencePoint(), p)) {
            if (!this.isDeleting) {
                this.isDeleting = true;
                this.eraseSourceFeedback(request);
                this.showDeleteBendpointFeedback(request);
            }
            return;
        }
        if (this.isDeleting) {
            this.isDeleting = false;
            this.eraseSourceFeedback(request);
        }
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        List constraint = (List)this.getConnection().getRoutingConstraint();
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        constraint.set(request.getIndex(), bp);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    public void showSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("create bendpoint".equals(request.getType())) {
            this.showCreateBendpointFeedback((BendpointRequest)request);
        }
    }
}

