/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.internal.Timer;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTreeContainerEditPolicy
extends AbstractEditPolicy {
    private Timer autoExpandTimer = new Timer();

    public AbstractTreeContainerEditPolicy() {
        this.autoExpandTimer.cancel();
    }

    protected abstract Command getAddCommand(ChangeBoundsRequest var1);

    protected abstract Command getCreateCommand(CreateRequest var1);

    protected abstract Command getMoveChildrenCommand(ChangeBoundsRequest var1);

    private void eraseAddFeedback(Request req) {
        this.getTree().setInsertMark(null, true);
    }

    private void eraseCreateFeedback(Request req) {
        this.eraseAddFeedback(req);
        this.autoExpandTimer.cancel();
    }

    private void eraseMoveFeedback(Request req) {
        this.eraseAddFeedback(req);
    }

    public void eraseTargetFeedback(Request req) {
        if (req.getType().equals("move")) {
            this.eraseMoveFeedback(req);
        }
        if (req.getType().equals("add children")) {
            this.eraseAddFeedback(req);
        }
        if (req.getType().equals("create child")) {
            this.eraseCreateFeedback(req);
        }
    }

    protected int findIndexOfTreeItemAt(Point pt) {
        int index = -1;
        List children = this.getHost().getChildren();
        TreeItem item = this.findTreeItemAt(pt);
        if (item != null && (index = children.indexOf(item.getData())) >= 0 && !this.isInUpperHalf(item.getBounds(), pt)) {
            ++index;
        }
        return index;
    }

    private TreeItem findTreeItemAt(Point pt) {
        return this.getTree().getItem(new org.eclipse.swt.graphics.Point(pt.x, pt.y));
    }

    public Command getCommand(Request req) {
        if (req.getType().equals("move children")) {
            return this.getMoveChildrenCommand((ChangeBoundsRequest)req);
        }
        if (req.getType().equals("add children")) {
            return this.getAddCommand((ChangeBoundsRequest)req);
        }
        if (req.getType().equals("create child")) {
            return this.getCreateCommand((CreateRequest)req);
        }
        return null;
    }

    public EditPart getTargetEditPart(Request req) {
        if (req.getType().equals("add children") || req.getType().equals("move") || req.getType().equals("create child")) {
            DropRequest drop = (DropRequest)((Object)req);
            org.eclipse.swt.graphics.Point where = new org.eclipse.swt.graphics.Point(drop.getLocation().x, drop.getLocation().y);
            Widget widget = ((TreeEditPart)this.getHost()).getWidget();
            if (widget instanceof Tree) {
                return this.getHost();
            }
            TreeItem treeitem = (TreeItem)widget;
            Rectangle bounds = treeitem.getBounds();
            int fudge = bounds.height / 5;
            Rectangle inner = new Rectangle(bounds.x, bounds.y + fudge, bounds.width, bounds.height - fudge * 2);
            if (!bounds.contains(where) || inner.contains(where)) {
                return this.getHost();
            }
        }
        return null;
    }

    private Tree getTree() {
        Widget widget = ((TreeEditPart)this.getHost()).getWidget();
        if (widget instanceof Tree) {
            return (Tree)widget;
        }
        return ((TreeItem)widget).getParent();
    }

    private void insertMarkAfterLastChild(TreeItem[] children) {
        if (children != null && children.length > 0) {
            TreeItem item = children[children.length - 1];
            this.getTree().setInsertMark(item, false);
        }
    }

    private boolean isInUpperHalf(Rectangle rect, Point pt) {
        Rectangle tempRect = new Rectangle(rect.x, rect.y, rect.width, rect.height / 2);
        return tempRect.contains(new org.eclipse.swt.graphics.Point(pt.x, pt.y));
    }

    private void showAddFeedback(Request req) {
        if (!(req instanceof ChangeBoundsRequest)) {
            return;
        }
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        Tree tree = this.getTree();
        Point pt = request.getLocation();
        TreeItem item = this.findTreeItemAt(pt);
        if (item == null) {
            Widget widget = ((TreeEditPart)this.getHost()).getWidget();
            if (widget == tree) {
                this.insertMarkAfterLastChild(tree.getItems());
            }
        } else if (item == ((TreeEditPart)this.getHost()).getWidget()) {
            this.insertMarkAfterLastChild(item.getItems());
        } else {
            boolean before = this.isInUpperHalf(item.getBounds(), pt);
            tree.setInsertMark(item, before);
        }
    }

    private void showCreateFeedback(Request req) {
        if (!(req instanceof CreateRequest)) {
            return;
        }
        CreateRequest request = (CreateRequest)req;
        Point pt = request.getLocation();
        final Tree tree = this.getTree();
        TreeItem item = this.findTreeItemAt(pt);
        if (item == null) {
            Widget widget = ((TreeEditPart)this.getHost()).getWidget();
            if (widget == tree) {
                this.insertMarkAfterLastChild(tree.getItems());
            }
        } else if (item == ((TreeEditPart)this.getHost()).getWidget()) {
            this.insertMarkAfterLastChild(item.getItems());
        } else {
            boolean before = this.isInUpperHalf(item.getBounds(), pt);
            tree.setInsertMark(item, before);
        }
        if (!this.autoExpandTimer.hasStopped()) {
            return;
        }
        this.autoExpandTimer = new Timer();
        this.autoExpandTimer.scheduleRepeatedly(new Runnable(){

            public void run() {
                Display display = tree.getDisplay();
                display.syncExec(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Widget widget = ((TreeEditPart)1.access$0(this.this$1).getHost()).getWidget();
                        if (widget instanceof TreeItem) {
                            ((TreeItem)widget).setExpanded(true);
                        }
                        AbstractTreeContainerEditPolicy.access$0(1.access$0(this.this$1)).cancel();
                    }
                });
            }

            static /* synthetic */ AbstractTreeContainerEditPolicy access$0(1 var0) {
                return var0.AbstractTreeContainerEditPolicy.this;
            }
        }, 500, 10000);
    }

    private void showMoveFeedback(Request req) {
        this.showAddFeedback(req);
    }

    public void showTargetFeedback(Request req) {
        if (req.getType().equals("move")) {
            this.showMoveFeedback(req);
        }
        if (req.getType().equals("add children")) {
            this.showAddFeedback(req);
        }
        if (req.getType().equals("create child")) {
            this.showCreateFeedback(req);
        }
    }

    static /* synthetic */ Timer access$0(AbstractTreeContainerEditPolicy abstractTreeContainerEditPolicy) {
        return abstractTreeContainerEditPolicy.autoExpandTimer;
    }
}

