/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;

public class ViewportExposeHelper
implements ExposeHelper {
    private GraphicalEditPart owner;

    public ViewportExposeHelper(GraphicalEditPart owner) {
        this.owner = owner;
    }

    public void exposeDescendant(EditPart part) {
        Viewport port = this.findViewport(this.owner);
        if (port == null) {
            return;
        }
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getExpanded(5, 5);
        target.translateToAbsolute((Translatable)exposeRegion);
        Point offset = port.getContents().getBounds().getLocation();
        port.getContents().translateToAbsolute((Translatable)offset);
        exposeRegion.translate(offset.negate());
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = Point.min((Point)topLeft, (Point)Point.max((Point)bottomRight, (Point)port.getViewLocation()));
        Point startLocation = port.getViewLocation();
        int dx = finalLocation.x - startLocation.x;
        int dy = finalLocation.y - startLocation.y;
        int FRAMES = (Math.abs(dx) + Math.abs(dy)) / 15;
        FRAMES = Math.max(FRAMES, 3);
        FRAMES = Math.min(FRAMES, 8);
        int stepX = Math.min(dx / FRAMES, viewportSize.width / 3);
        int stepY = Math.min(dy / FRAMES, viewportSize.height / 3);
        int i = 1;
        while (i < FRAMES) {
            port.setViewLocation(startLocation.x + stepX * i, startLocation.y + stepY * i);
            port.getUpdateManager().performUpdate();
            ++i;
        }
        port.setViewLocation(finalLocation);
    }

    private Viewport findViewport(GraphicalEditPart part) {
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? part.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != part.getFigure() && figure != null);
        return port;
    }
}

