/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.accessibility.AccessibleControlEvent;

public abstract class AbstractGraphicalEditPart
extends AbstractEditPart
implements GraphicalEditPart {
    protected IFigure figure;
    protected List handles = new ArrayList(8);
    protected List sourceConnections;
    protected List targetConnections;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void activate() {
        super.activate();
        List l = this.getSourceConnections();
        int i = 0;
        while (i < l.size()) {
            ((EditPart)l.get(i)).activate();
            ++i;
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, index);
    }

    protected void addSourceConnection(ConnectionEditPart connection, int index) {
        this.primAddSourceConnection(connection, index);
        connection.setSource(this);
        if (this.isActive()) {
            connection.activate();
        }
        this.fireSourceConnectionAdded(connection, index);
    }

    protected void addTargetConnection(ConnectionEditPart connection, int index) {
        this.primAddTargetConnection(connection, index);
        connection.setTarget(this);
        this.fireTargetConnectionAdded(connection, index);
    }

    protected abstract IFigure createFigure();

    public void deactivate() {
        List l = this.getSourceConnections();
        int i = 0;
        while (i < l.size()) {
            ((EditPart)l.get(i)).deactivate();
            ++i;
        }
        super.deactivate();
    }

    public void dispose() {
        List conns = this.getSourceConnections();
        int i = 0;
        while (i < conns.size()) {
            ((ConnectionEditPart)conns.get(i)).setSource(null);
            ++i;
        }
        conns = this.getTargetConnections();
        i = 0;
        while (i < conns.size()) {
            ((ConnectionEditPart)conns.get(i)).setTarget(null);
            ++i;
        }
        super.dispose();
    }

    protected void fireRemovingSourceConnection(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.NodeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.eventListeners.getListeners((Class)clazz);
        NodeListener listener = null;
        while (listeners.hasNext()) {
            listener = (NodeListener)listeners.next();
            listener.removingSourceConnection(connection, index);
        }
    }

    protected void fireRemovingTargetConnection(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.NodeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.eventListeners.getListeners((Class)clazz);
        NodeListener listener = null;
        while (listeners.hasNext()) {
            listener = (NodeListener)listeners.next();
            listener.removingTargetConnection(connection, index);
        }
    }

    protected void fireSourceConnectionAdded(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.NodeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.eventListeners.getListeners((Class)clazz);
        NodeListener listener = null;
        while (listeners.hasNext()) {
            listener = (NodeListener)listeners.next();
            listener.sourceConnectionAdded(connection, index);
        }
    }

    protected void fireTargetConnectionAdded(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.NodeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.eventListeners.getListeners((Class)clazz);
        NodeListener listener = null;
        while (listeners.hasNext()) {
            listener = (NodeListener)listeners.next();
            listener.targetConnectionAdded(connection, index);
        }
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.AccessibleHandleProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new MergedAccessibleHandles(this.getEditPolicyIterator());
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.gef.AccessibleAnchorProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return new DefaultAccessibleAnchorProvider();
        }
        return super.getAdapter(key);
    }

    public IFigure getContentPane() {
        return this.getFigure();
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker(this);
    }

    public final IFigure getFigure() {
        if (this.figure == null) {
            this.setFigure(this.createFigure());
        }
        return this.figure;
    }

    protected IFigure getLayer(Object layer) {
        LayerManager manager = (LayerManager)this.getViewer().getEditPartRegistry().get(LayerManager.ID);
        return manager.getLayer(layer);
    }

    protected List getModelSourceConnections() {
        return Collections.EMPTY_LIST;
    }

    protected List getModelTargetConnections() {
        return Collections.EMPTY_LIST;
    }

    protected final IFigure getParentingFigure() throws Exception {
        return null;
    }

    public List getSourceConnections() {
        if (this.sourceConnections == null) {
            return Collections.EMPTY_LIST;
        }
        return this.sourceConnections;
    }

    public List getTargetConnections() {
        if (this.targetConnections == null) {
            return Collections.EMPTY_LIST;
        }
        return this.targetConnections;
    }

    protected void primAddSourceConnection(ConnectionEditPart connection, int index) {
        if (this.sourceConnections == null) {
            this.sourceConnections = new ArrayList();
        }
        this.sourceConnections.add(index, connection);
    }

    protected void primAddTargetConnection(ConnectionEditPart connection, int index) {
        if (this.targetConnections == null) {
            this.targetConnections = new ArrayList();
        }
        this.targetConnections.add(index, connection);
    }

    protected void primRemoveSourceConnection(ConnectionEditPart connection) {
        this.sourceConnections.remove(connection);
    }

    protected void primRemoveTargetConnection(ConnectionEditPart editPart) {
        this.targetConnections.remove(editPart);
    }

    public void refresh() {
        super.refresh();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    protected void refreshSourceConnections() {
        ConnectionEditPart editPart;
        Hashtable<Object, ConnectionEditPart> modelToEditPart = new Hashtable<Object, ConnectionEditPart>();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            editPart = (ConnectionEditPart)editParts.get(i);
            modelToEditPart.put(editPart.getModel(), editPart);
            ++i;
        }
        ArrayList modelObjects = this.getModelSourceConnections();
        if (modelObjects == null) {
            modelObjects = new ArrayList();
        }
        i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            editPart = (ConnectionEditPart)modelToEditPart.get(model);
            if (editPart != null) {
                this.reorderSourceConnection(editPart, i);
            } else {
                editPart = this.createOrFindConnection(model);
                this.addSourceConnection(editPart, i);
            }
            ++i;
        }
        ArrayList trash = new ArrayList();
        while (i < editParts.size()) {
            trash.add(editParts.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            this.removeSourceConnection((ConnectionEditPart)trash.get(i));
            ++i;
        }
    }

    protected void refreshTargetConnections() {
        ConnectionEditPart editPart;
        Hashtable<Object, ConnectionEditPart> mapModelToEditPart = new Hashtable<Object, ConnectionEditPart>();
        List connections = this.getTargetConnections();
        int i = 0;
        while (i < connections.size()) {
            editPart = (ConnectionEditPart)connections.get(i);
            mapModelToEditPart.put(editPart.getModel(), editPart);
            ++i;
        }
        ArrayList modelObjects = this.getModelTargetConnections();
        if (modelObjects == null) {
            modelObjects = new ArrayList();
        }
        i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            ConnectionEditPart connectionEditPart = editPart = i < connections.size() ? (ConnectionEditPart)connections.get(i) : null;
            if (editPart == null || editPart.getModel() != model) {
                editPart = (ConnectionEditPart)mapModelToEditPart.get(model);
                if (editPart != null) {
                    this.reorderTargetConnection(editPart, i);
                } else {
                    editPart = this.createOrFindConnection(model);
                    this.addTargetConnection(editPart, i);
                }
            }
            ++i;
        }
        ArrayList trash = new ArrayList();
        while (i < connections.size()) {
            trash.add(connections.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            this.removeTargetConnection((ConnectionEditPart)trash.get(i));
            ++i;
        }
    }

    protected void registerVisuals() {
        this.getViewer().getVisualPartMap().put(this.getFigure(), this);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().remove(child);
    }

    protected void removeSourceConnection(ConnectionEditPart connection) {
        this.fireRemovingSourceConnection(connection, this.getSourceConnections().indexOf(connection));
        connection.deactivate();
        connection.setSource(null);
        this.primRemoveSourceConnection(connection);
    }

    protected void removeTargetConnection(ConnectionEditPart connection) {
        this.fireRemovingTargetConnection(connection, this.getTargetConnections().indexOf(connection));
        connection.setTarget(null);
        this.primRemoveTargetConnection(connection);
    }

    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPane().getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        super.reorderChild(child, index);
        this.getContentPane().setConstraint(childFigure, constraint);
    }

    protected void reorderSourceConnection(ConnectionEditPart editPart, int index) {
        this.primRemoveSourceConnection(editPart);
        this.primAddSourceConnection(editPart, index);
    }

    protected void reorderTargetConnection(ConnectionEditPart editPart, int index) {
        this.primRemoveTargetConnection(editPart);
        this.primAddTargetConnection(editPart, index);
    }

    protected void setFigure(IFigure figure) {
        this.figure = figure;
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        this.getContentPane().setConstraint(childFigure, constraint);
    }

    protected boolean shouldInitialize() {
        return super.shouldInitialize() && this.getFigure() != null;
    }

    protected void unregister() {
        super.unregister();
        this.getViewer().getVisualPartMap().remove(this.getFigure());
    }

    protected abstract class AccessibleGraphicalEditPart
    extends AccessibleEditPart {
        static /* synthetic */ Class class$0;

        protected AccessibleGraphicalEditPart() {
        }

        public void getChildCount(AccessibleControlEvent e) {
            e.detail = AbstractGraphicalEditPart.this.getChildren().size();
        }

        public void getChildren(AccessibleControlEvent e) {
            List list = AbstractGraphicalEditPart.this.getChildren();
            Object[] children = new Object[list.size()];
            int i = 0;
            while (i < list.size()) {
                AccessibleEditPart access;
                EditPart part = (EditPart)list.get(i);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.gef.AccessibleEditPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((access = (AccessibleEditPart)((Object)part.getAdapter(clazz))) == null) {
                    return;
                }
                children[i] = new Integer(access.getAccessibleID());
                ++i;
            }
            e.children = children;
        }

        public void getLocation(AccessibleControlEvent e) {
            Rectangle bounds = AbstractGraphicalEditPart.this.getFigure().getBounds().getCopy();
            AbstractGraphicalEditPart.this.getFigure().translateToAbsolute((Translatable)bounds);
            org.eclipse.swt.graphics.Point p = new org.eclipse.swt.graphics.Point(0, 0);
            p = AbstractGraphicalEditPart.this.getViewer().getControl().toDisplay(p);
            e.x = bounds.x + p.x;
            e.y = bounds.y + p.y;
            e.width = bounds.width;
            e.height = bounds.height;
        }

        public void getState(AccessibleControlEvent e) {
            e.detail = AbstractGraphicalEditPart.this.getSelected() != 0 ? 2 : 0;
        }
    }

    protected class DefaultAccessibleAnchorProvider
    implements AccessibleAnchorProvider {
        protected DefaultAccessibleAnchorProvider() {
        }

        private List getDefaultLocations() {
            ArrayList<Point> list = new ArrayList<Point>();
            Rectangle r = AbstractGraphicalEditPart.this.getFigure().getBounds();
            Point p = r.getTopRight().translate(-1, r.height / 3);
            AbstractGraphicalEditPart.this.getFigure().translateToAbsolute((Translatable)p);
            list.add(p);
            return list;
        }

        public List getSourceAnchorLocations() {
            return this.getDefaultLocations();
        }

        public List getTargetAnchorLocations() {
            return this.getDefaultLocations();
        }
    }

    static class MergedAccessibleHandles
    implements AccessibleHandleProvider {
        List locations = new ArrayList();
        static /* synthetic */ Class class$0;

        MergedAccessibleHandles(AbstractEditPart.EditPolicyIterator iter) {
            while (iter.hasNext()) {
                AccessibleHandleProvider adapter;
                EditPolicy policy = iter.next();
                if (!(policy instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)policy;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.gef.AccessibleHandleProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (AccessibleHandleProvider)adaptable.getAdapter((Class)clazz)) == null) continue;
                this.locations.addAll(adapter.getAccessibleHandleLocations());
            }
        }

        public List getAccessibleHandleLocations() {
            return this.locations;
        }
    }
}

