/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.GEF;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class DelegatingDropAdapter
implements DropTargetListener {
    private List listeners = new ArrayList();
    private TransferDropTargetListener currentListener;
    private int origDropType;

    public void addDropTargetListener(TransferDropTargetListener listener) {
        this.listeners.add(listener);
    }

    public void dragEnter(final DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Enter: " + this.toString());
        }
        this.setOriginalDropType(event.detail);
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                DelegatingDropAdapter.this.updateCurrentListener(event);
                if (DelegatingDropAdapter.this.getCurrentListener() != null) {
                    DelegatingDropAdapter.this.getCurrentListener().dragEnter(event);
                }
            }
        });
    }

    public void dragLeave(final DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Leave: " + this.toString());
        }
        if (this.getCurrentListener() != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dragLeave(event);
                }
            });
        }
    }

    public void dragOperationChanged(final DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Operation Changed to: " + event.detail);
        }
        this.setOriginalDropType(event.detail);
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                DelegatingDropAdapter.this.updateCurrentListener(event);
                if (DelegatingDropAdapter.this.getCurrentListener() != null) {
                    DelegatingDropAdapter.this.getCurrentListener().dragOperationChanged(event);
                }
            }
        });
    }

    public void dragOver(final DropTargetEvent event) {
        this.updateCurrentListener(event);
        if (this.getCurrentListener() != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dragOver(event);
                }
            });
        } else {
            event.detail = 0;
        }
    }

    public void drop(final DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drop: " + this.toString());
        }
        if (this.getCurrentListener() != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().drop(event);
                }
            });
        }
        this.setCurrentListener(null);
    }

    public void dropAccept(final DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drop Accept: " + this.toString());
        }
        if (this.getCurrentListener() != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dropAccept(event);
                }
            });
        }
    }

    private TransferDropTargetListener getCurrentListener() {
        return this.currentListener;
    }

    private int getOriginalDropType() {
        return this.origDropType;
    }

    public Transfer[] getTransferTypes() {
        Transfer[] types = new Transfer[this.listeners.size()];
        int i = 0;
        while (i < this.listeners.size()) {
            TransferDropTargetListener listener = (TransferDropTargetListener)this.listeners.get(i);
            types[i] = listener.getTransfer();
            ++i;
        }
        return types;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void removeDropTargetListener(TransferDropTargetListener listener) {
        this.listeners.remove(listener);
    }

    private boolean setCurrentListener(TransferDropTargetListener listener) {
        if (this.currentListener == listener) {
            return false;
        }
        if (this.currentListener != null) {
            this.currentListener.deactivate();
        }
        this.currentListener = listener;
        if (GEF.DebugDND) {
            GEF.debug("Current listener " + listener);
        }
        if (this.currentListener != null) {
            this.currentListener.activate();
        }
        return true;
    }

    private void setOriginalDropType(int type) {
        this.origDropType = type;
    }

    private void updateCurrentListener(DropTargetEvent event) {
        int temp = event.detail;
        event.detail = this.getOriginalDropType();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferDropTargetListener listener = (TransferDropTargetListener)iter.next();
            if (!listener.isEnabled(event)) continue;
            if (!this.setCurrentListener(listener)) {
                event.detail = temp;
            }
            return;
        }
        this.setCurrentListener(null);
        event.detail = 0;
    }
}

