/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.GEF;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public class DelegatingDragAdapter
implements DragSourceListener {
    private List listeners = new ArrayList();
    private List activeListeners = new ArrayList();
    private TransferDragSourceListener currentListener;

    public void addDragSourceListener(TransferDragSourceListener listener) {
        this.listeners.add(listener);
    }

    public void dragFinished(DragSourceEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Finished: " + this.toString());
        }
        if (this.currentListener != null) {
            this.currentListener.dragFinished(event);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Set Data: " + this.toString());
        }
        this.updateCurrentListener(event);
        if (this.currentListener != null) {
            this.currentListener.dragSetData(event);
        }
    }

    public void dragStart(DragSourceEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Start: " + this.toString());
        }
        boolean origDoit = event.doit;
        boolean doit = false;
        ArrayList<Transfer> transfers = new ArrayList<Transfer>(this.listeners.size());
        int i = 0;
        while (i < this.listeners.size()) {
            TransferDragSourceListener listener = (TransferDragSourceListener)this.listeners.get(i);
            event.doit = origDoit;
            listener.dragStart(event);
            if (event.doit) {
                transfers.add(listener.getTransfer());
                this.activeListeners.add(listener);
            }
            doit = doit || event.doit;
            ++i;
        }
        if (doit) {
            ((DragSource)event.widget).setTransfer(transfers.toArray(new Transfer[transfers.size()]));
        }
        event.doit = doit;
    }

    private void updateCurrentListener(DragSourceEvent event) {
        this.currentListener = null;
        if (event.dataType == null) {
            return;
        }
        Iterator iter = this.activeListeners.iterator();
        while (iter.hasNext()) {
            TransferDragSourceListener listener = (TransferDragSourceListener)iter.next();
            if (!listener.getTransfer().isSupportedType(event.dataType)) continue;
            this.currentListener = listener;
            return;
        }
    }

    public Transfer[] getTransferTypes() {
        Transfer[] types = new Transfer[this.listeners.size()];
        int i = 0;
        while (i < this.listeners.size()) {
            TransferDragSourceListener listener = (TransferDragSourceListener)this.listeners.get(i);
            types[i] = listener.getTransfer();
            ++i;
        }
        return types;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void removeDragSourceListener(TransferDragSourceListener listener) {
        this.listeners.remove(listener);
    }
}

