/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GEF;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class AbstractTransferDropTargetListener
implements TransferDropTargetListener {
    private DropTargetEvent currentEvent;
    private EditPartViewer viewer;
    private Transfer transfer;
    private EditPart target;
    private Request request;
    private int oldDropType;

    public AbstractTransferDropTargetListener(EditPartViewer viewer) {
        this.setViewer(viewer);
    }

    public AbstractTransferDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        this.setViewer(viewer);
        this.setTransfer(xfer);
    }

    public void activate() {
    }

    protected abstract boolean canHandleDrop(DropTargetEvent var1);

    protected Request createTargetRequest() {
        return new Request();
    }

    public void deactivate() {
        this.setTargetEditPart(null);
        this.request = null;
    }

    public void dragEnter(DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Enter: " + this.toString());
        }
        this.setCurrentEvent(event);
        this.handleDragEnter();
    }

    public void dragLeave(DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Leave: " + this.toString());
        }
        this.setCurrentEvent(event);
        this.handleDragLeave();
        this.unload();
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Operation Changed: " + this.toString());
        }
        this.setCurrentEvent(event);
        this.handleDragOperationChanged();
    }

    public void dragOver(DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drag Over: " + this.toString());
        }
        this.setCurrentEvent(event);
        this.handleDragOver();
    }

    public void drop(DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drop: " + this.toString());
        }
        this.setCurrentEvent(event);
        this.handleDrop();
    }

    public void dropAccept(DropTargetEvent event) {
        if (GEF.DebugDND) {
            GEF.debug("Drop Accept: " + this.toString());
        }
        this.setCurrentEvent(event);
        this.handleDropAccept();
    }

    protected void eraseTargetFeedback() {
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().eraseTargetFeedback(this.getTargetRequest());
        }
    }

    public DropTargetEvent getCurrentEvent() {
        return this.currentEvent;
    }

    protected Point getDropLocation() {
        org.eclipse.swt.graphics.Point swt = new org.eclipse.swt.graphics.Point(this.getCurrentEvent().x, this.getCurrentEvent().y);
        DropTarget target = (DropTarget)this.getCurrentEvent().widget;
        swt = target.getControl().toControl(swt);
        return new Point(swt.x, swt.y);
    }

    protected int getPreviousDropType() {
        return this.oldDropType;
    }

    protected EditPart getTargetEditPart() {
        return this.target;
    }

    protected Request getTargetRequest() {
        if (this.request == null) {
            this.request = this.createTargetRequest();
        }
        return this.request;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    protected boolean handleDragEnter() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        return true;
    }

    protected boolean handleDragLeave() {
        this.eraseTargetFeedback();
        return true;
    }

    protected boolean handleDragOperationChanged() {
        return false;
    }

    protected boolean handleDragOver() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        return true;
    }

    protected boolean handleDrop() {
        if (this.getCurrentEvent().data == null) {
            this.getCurrentEvent().detail = 0;
            return false;
        }
        this.updateTargetRequest();
        this.updateTargetEditPart();
        Command command = this.getTargetEditPart().getCommand(this.getTargetRequest());
        this.getViewer().getEditDomain().getCommandStack().execute(command);
        return true;
    }

    protected boolean handleDropAccept() {
        return false;
    }

    protected boolean handleEnteredEditPart() {
        this.showTargetFeedback();
        return true;
    }

    protected boolean handleExitingEditPart() {
        this.eraseTargetFeedback();
        return true;
    }

    public boolean isEnabled(DropTargetEvent event) {
        int i = 0;
        while (i < event.dataTypes.length) {
            if (this.getTransfer().isSupportedType(event.dataTypes[i]) && this.canHandleDrop(event)) {
                this.setCurrentEvent(event);
                event.currentDataType = event.dataTypes[i];
                this.updateTargetRequest();
                this.updateTargetEditPart();
                Command command = null;
                if (this.getTargetEditPart() != null) {
                    command = this.getTargetEditPart().getCommand(this.getTargetRequest());
                }
                if (command != null && command.canExecute()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void setCurrentEvent(DropTargetEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    protected void setTargetEditPart(EditPart ep) {
        if (ep != this.target) {
            if (this.target != null) {
                this.handleExitingEditPart();
                if (GEF.DebugDND) {
                    GEF.debug("Exited EditPart: " + this.target.toString());
                }
            }
            this.target = ep;
            this.handleEnteredEditPart();
            GEF.debug("Entered EditPart: " + this.target);
        }
    }

    public void setTransfer(Transfer xfer) {
        this.transfer = xfer;
    }

    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    protected void showTargetFeedback() {
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().showTargetFeedback(this.getTargetRequest());
        }
    }

    public void unload() {
        this.eraseTargetFeedback();
        this.request = null;
    }

    protected void updateTargetEditPart() {
        EditPart ep = this.getViewer().findObjectAt(this.getDropLocation());
        if (ep != null) {
            ep = ep.getTargetEditPart(this.getTargetRequest());
        }
        this.setTargetEditPart(ep);
    }

    protected abstract void updateTargetRequest();
}

