/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Stack;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.UnexecutableCommand;

public class DefaultCommandStack
implements CommandStack {
    private Stack undo = new Stack();
    private Stack redo = new Stack();
    protected Command mostRecentCommand;
    protected List listeners = new ArrayList();
    protected int saveIndex = -1;

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public boolean canRedo() {
        return !this.redo.isEmpty();
    }

    public boolean canRedoCommand(Command command) {
        return this.redo.contains(command);
    }

    public boolean canUndo() {
        if (this.undo.size() == 0) {
            return false;
        }
        return ((Command)this.undo.lastElement()).canUndo();
    }

    public boolean canUndoCommand(Command command) {
        return this.undo.contains(command);
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.flushRedo();
        try {
            try {
                this.mostRecentCommand = null;
                command.execute();
                this.mostRecentCommand = command;
                this.undo.push(command);
            }
            catch (RuntimeException exception) {
                command.dispose();
                this.flushUndo();
                this.undo.push(UnexecutableCommand.INSTANCE);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.notifyListeners();
            throw throwable;
        }
        Object var3_5 = null;
        this.notifyListeners();
    }

    public void flush() {
        this.flushUndo();
        this.flushRedo();
        this.notifyListeners();
    }

    protected void flushRedo() {
        while (!this.redo.isEmpty()) {
            ((Command)this.redo.pop()).dispose();
        }
    }

    protected void flushUndo() {
        while (!this.undo.isEmpty()) {
            ((Command)this.undo.pop()).dispose();
        }
    }

    public Object[] getCommands() {
        ArrayList commands = new ArrayList(this.undo);
        int i = this.redo.size() - 1;
        while (i >= 0) {
            commands.add(this.redo.get(i));
            --i;
        }
        return commands.toArray();
    }

    public Command getMostRecentCommand() {
        return this.mostRecentCommand;
    }

    public Command getRedoCommand() {
        return this.redo.isEmpty() ? null : (Command)this.redo.peek();
    }

    public Command getUndoCommand() {
        return this.undo.isEmpty() ? null : (Command)this.undo.peek();
    }

    public boolean isSaveNeeded() {
        return !this.undo.isEmpty();
    }

    protected void notifyListeners() {
        EventObject event = new EventObject(this);
        int i = 0;
        while (i < this.listeners.size()) {
            ((CommandStackListener)this.listeners.get(i)).commandStackChanged(event);
            ++i;
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = (Command)this.redo.pop();
        try {
            try {
                this.mostRecentCommand = null;
                command.redo();
                this.undo.push(command);
                this.mostRecentCommand = command;
            }
            catch (RuntimeException exception) {
                this.flushRedo();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.notifyListeners();
            throw throwable;
        }
        Object var3_5 = null;
        this.notifyListeners();
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    public void saveIsDone() {
        this.flush();
    }

    public void undo() {
        Command command = (Command)this.undo.pop();
        try {
            command.undo();
            this.mostRecentCommand = command;
            this.redo.push(command);
        }
        catch (Exception exception) {
            this.mostRecentCommand = null;
            this.flush();
        }
        this.notifyListeners();
    }
}

