/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;

public class CompoundCommand
extends AbstractCommand {
    protected List commandList = new ArrayList();

    public CompoundCommand() {
    }

    public CompoundCommand(String desc) {
        super(desc);
    }

    public void add(Command command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public boolean canExecute() {
        if (this.commandList.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.commandList.size()) {
            Command cmd = (Command)this.commandList.get(i);
            if (cmd == null) {
                return false;
            }
            if (!cmd.canExecute()) {
                return false;
            }
            ++i;
        }
        return super.canExecute();
    }

    public boolean canUndo() {
        if (this.commandList.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.commandList.size()) {
            Command cmd = (Command)this.commandList.get(i);
            if (cmd == null) {
                return false;
            }
            if (!cmd.canUndo()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void dispose() {
        int i = 0;
        while (i < this.commandList.size()) {
            Command c = (Command)this.commandList.get(i);
            if (c != null) {
                c.dispose();
            }
            ++i;
        }
    }

    public void execute() {
        int i = 0;
        while (i < this.commandList.size()) {
            Command cmd = (Command)this.commandList.get(i);
            cmd.execute();
            ++i;
        }
    }

    public Collection getAffectedObjects() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.commandList.size()) {
            list.addAll(((Command)this.commandList.get(i)).getAffectedObjects());
            ++i;
        }
        return list;
    }

    public Object[] getChildren() {
        return this.commandList.toArray();
    }

    public List getCommands() {
        return this.commandList;
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null && this.commandList.isEmpty()) {
            return null;
        }
        if (label != null) {
            return label;
        }
        return ((Command)this.commandList.get(0)).getLabel();
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    public void redo() {
        int i = 0;
        while (i < this.commandList.size()) {
            ((Command)this.commandList.get(i)).redo();
            ++i;
        }
    }

    public int size() {
        return this.commandList.size();
    }

    public void undo() {
        int i = this.commandList.size() - 1;
        while (i >= 0) {
            ((Command)this.commandList.get(i)).undo();
            --i;
        }
    }

    public Command unwrap() {
        switch (this.commandList.size()) {
            case 0: {
                this.dispose();
                return UnexecutableCommand.INSTANCE;
            }
            case 1: {
                Command result = (Command)this.commandList.remove(0);
                this.dispose();
                return result;
            }
        }
        return this;
    }
}

