/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public abstract class AbstractCommand
implements Command {
    private String label;
    private String description = null;
    private String debugLabel;

    public AbstractCommand() {
    }

    public AbstractCommand(String label) {
        this.setLabel(label);
    }

    public Collection getAffectedObjects() {
        return Collections.EMPTY_LIST;
    }

    public String getDebugLabel() {
        return String.valueOf(this.debugLabel) + ' ' + this.getLabel();
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public final Collection getResult() {
        return Collections.EMPTY_LIST;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public Command chain(Command command) {
        if (command == null) {
            return this;
        }
        class ChainedCompoundCommand
        extends CompoundCommand {
            ChainedCompoundCommand() {
            }

            public Command chain(Command c) {
                this.add(c);
                return this;
            }
        }
        ChainedCompoundCommand result = new ChainedCompoundCommand();
        result.setDebugLabel("chained commands");
        result.add(this);
        result.add(command);
        return result;
    }

    public void dispose() {
    }

    public void execute() {
    }

    public void redo() {
        this.execute();
    }

    public void setDebugLabel(String label) {
        this.debugLabel = label;
    }

    public void setDescription(String label) {
        this.label = label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void undo() {
    }
}

