/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import org.eclipse.swt.events.KeyEvent;

public class KeyStroke {
    int stateMask;
    char character;
    boolean onPressed;
    int keyCode;

    KeyStroke(KeyEvent event, boolean pressed) {
        this.onPressed = pressed;
        this.stateMask = event.stateMask;
        this.character = event.character;
        this.keyCode = event.keyCode;
    }

    KeyStroke(int keyCode, int stateMask, boolean onPressed) {
        this.keyCode = keyCode;
        this.stateMask = stateMask;
        this.onPressed = onPressed;
    }

    KeyStroke(char character, int stateMask, boolean onPressed) {
        this.character = character;
        this.stateMask = stateMask;
        this.onPressed = onPressed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyStroke) {
            KeyStroke stroke = (KeyStroke)obj;
            return stroke.character == this.character && stroke.keyCode == this.keyCode && stroke.onPressed == this.onPressed && stroke.stateMask == this.stateMask;
        }
        return false;
    }

    public static KeyStroke getPressed(char character, int stateMask) {
        return new KeyStroke(character, stateMask, true);
    }

    public static KeyStroke getPressed(int keyCode, int stateMask) {
        return new KeyStroke(keyCode, stateMask, true);
    }

    public static KeyStroke getReleased(char character, int stateMask) {
        return new KeyStroke(character, stateMask, false);
    }

    public static KeyStroke getReleased(int keyCode, int stateMask) {
        return new KeyStroke(keyCode, stateMask, false);
    }

    public int hashCode() {
        return (this.stateMask + 1) * ((this.character ^ this.keyCode) + 1) + (this.onPressed ? 0 : 1);
    }
}

