/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.DefaultCommandStack;
import org.eclipse.gef.palette.PaletteEvent;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.IEditorPart;

public class DefaultEditDomain
implements EditDomain {
    private Tool activeTool;
    private List viewers = new ArrayList();
    private Tool defaultTool;
    private PaletteViewer paletteViewer;
    private PaletteRoot paletteRoot;
    private CommandStack commandStack = this.createCommandStack();
    private IEditorPart editorPart;
    private PaletteListener paletteListener = new PaletteListener(){

        public void entrySelected(PaletteEvent event) {
            Object paletteEntry = event.getEntry();
            if (paletteEntry instanceof PaletteToolEntry) {
                DefaultEditDomain.this.setTool(((PaletteToolEntry)paletteEntry).getTool());
            } else if (paletteEntry == null) {
                DefaultEditDomain.this.setTool(null);
            }
        }

        public void newDefaultEntry(PaletteEvent event) {
            Object paletteEntry = event.getEntry();
            if (paletteEntry instanceof PaletteToolEntry) {
                DefaultEditDomain.this.setDefaultTool(((PaletteToolEntry)paletteEntry).getTool());
            } else {
                DefaultEditDomain.this.setDefaultTool(null);
            }
        }
    };

    public DefaultEditDomain(IEditorPart editorPart) {
        this.setEditorPart(editorPart);
        this.init();
    }

    public void addViewer(EditPartViewer viewer) {
        viewer.setEditDomain(this);
        if (!this.viewers.contains(viewer)) {
            this.viewers.add(viewer);
        }
    }

    protected CommandStack createCommandStack() {
        return new DefaultCommandStack();
    }

    public void focusGained(FocusEvent event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.focusGained(event, viewer);
        }
    }

    public void focusLost(FocusEvent event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.focusLost(event, viewer);
        }
    }

    public Tool getActiveTool() {
        return this.activeTool;
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public Tool getDefaultTool() {
        if (this.defaultTool == null) {
            this.defaultTool = new SelectionTool();
        }
        return this.defaultTool;
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    protected void init() {
        this.loadDefaultTool();
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyDown(keyEvent, viewer);
        }
    }

    public void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyUp(keyEvent, viewer);
        }
    }

    public void loadDefaultTool() {
        this.setTool(null);
        if (this.paletteViewer != null) {
            this.paletteViewer.setSelection(null);
            if (this.getActiveTool() == null) {
                this.setTool(this.getDefaultTool());
            }
        } else {
            this.setTool(this.getDefaultTool());
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDoubleClick(mouseEvent, viewer);
        }
    }

    public void mouseDown(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDown(mouseEvent, viewer);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDrag(mouseEvent, viewer);
        }
    }

    public void mouseHover(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseHover(mouseEvent, viewer);
        }
    }

    public void mouseMove(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseMove(mouseEvent, viewer);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseUp(mouseEvent, viewer);
        }
    }

    public void removeViewer(EditPartViewer viewer) {
        if (this.viewers.remove(viewer)) {
            viewer.setEditDomain(null);
        }
    }

    public void setCommandStack(CommandStack stack) {
        this.commandStack = stack;
    }

    public void setDefaultTool(Tool tool) {
        this.defaultTool = tool;
    }

    protected void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public void setPaletteRoot(PaletteRoot root) {
        this.paletteRoot = root;
        if (this.paletteViewer != null) {
            this.paletteViewer.setPaletteRoot(this.paletteRoot);
        }
        this.loadDefaultTool();
    }

    public void setPaletteViewer(PaletteViewer palette) {
        palette.addPaletteListener(this.paletteListener);
        this.paletteViewer = palette;
        if (this.paletteRoot != null) {
            this.paletteViewer.setPaletteRoot(this.paletteRoot);
            this.loadDefaultTool();
        }
    }

    public void setTool(Tool newTool) {
        if (this.activeTool != null) {
            this.activeTool.deactivate();
        }
        this.activeTool = newTool;
        if (this.activeTool != null) {
            this.activeTool.setEditDomain(this);
            this.activeTool.activate();
        }
    }

    public void viewerEntered(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.viewerEntered(mouseEvent, viewer);
        }
    }

    public void viewerExited(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.viewerExited(mouseEvent, viewer);
        }
    }
}

