/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime.jmx;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRoleSetting;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.generation.runtime.ModelTemplateHelper;
import com.sap.ide.webdynpro.generation.runtime.StringUtil;
import java.util.Arrays;
import java.util.Comparator;

public class JMXModelTemplateHelper
extends ModelTemplateHelper {
    private final Comparator propertyComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Property)o1).getName().compareTo(((Property)o2).getName());
        }
    };

    private String convertClassName(String name) {
        if (!name.startsWith("[")) {
            return name;
        }
        int dimension = 0;
        while (name.charAt(dimension) == '[') {
            ++dimension;
        }
        char type = name.charAt(dimension);
        StringBuffer result = new StringBuffer();
        switch (type) {
            case 'Z': {
                result.append("boolean");
                break;
            }
            case 'B': {
                result.append("byte");
                break;
            }
            case 'C': {
                result.append("char");
                break;
            }
            case 'S': {
                result.append("short");
                break;
            }
            case 'I': {
                result.append("int");
                break;
            }
            case 'J': {
                result.append("long");
                break;
            }
            case 'F': {
                result.append("float");
                break;
            }
            case 'D': {
                result.append("double");
                break;
            }
            case 'L': {
                result.append(this.convertClassName(name.substring(dimension + 1, name.length() - 1)));
            }
        }
        int i = 0;
        while (i < dimension) {
            result.append("[]");
            ++i;
        }
        return result.toString();
    }

    private String convertToInternalClassName(int dimension, String name) {
        if (dimension <= 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dimension) {
            sb.append('[');
            ++i;
        }
        if ("boolean".equals(name)) {
            sb.append('Z');
        } else if ("byte".equals(name)) {
            sb.append('B');
        } else if ("char".equals(name)) {
            sb.append('C');
        } else if ("short".equals(name)) {
            sb.append('S');
        } else if ("int".equals(name)) {
            sb.append('I');
        } else if ("long".equals(name)) {
            sb.append('J');
        } else if ("float".equals(name)) {
            sb.append('F');
        } else if ("double".equals(name)) {
            sb.append('D');
        } else {
            sb.append('L');
            sb.append(name);
            sb.append(';');
        }
        return sb.toString();
    }

    public String getReturnTypeName(Method method) {
        return this.convertClassName(super.getReturnTypeName(method));
    }

    public String getReturnTypeNameDeep(Method method) {
        String type = this.getReturnTypeName(method);
        int index = type.indexOf(91);
        if (index > 0) {
            return type.substring(0, index);
        }
        return type;
    }

    public boolean isReturnTypeArray(Method method) {
        return this.getReturnTypeName(method).endsWith("]");
    }

    public String getPropertyType(Property property) {
        if (property.hasType()) {
            return this.convertClassName(this.getQualifiedJavaClassName(property.getType()));
        }
        throw new RuntimeException("unable to determine type of model property " + property.getName());
    }

    public String getPropertyTypeDeep(Property property) {
        String type = this.getPropertyType(property);
        int index = type.indexOf(91);
        if (index > 0) {
            return type.substring(0, index);
        }
        return type;
    }

    public boolean isPropertyArray(Property property) {
        return this.getPropertyType(property).endsWith("]");
    }

    public Property[] getAllProperties(ModelClass modelClass) {
        Property[] result = this.getAllPropsInt(modelClass);
        Arrays.sort(result, this.propertyComparator);
        return result;
    }

    public ModelRelationRole[] getAllTargetRolesTo1(ModelClass modelClass) {
        return this.getAllTargetRolesTo1Int(modelClass);
    }

    public ModelRelationRole[] getAllTargetRolesToN(ModelClass modelClass) {
        return this.getAllTargetRolesToNInt(modelClass);
    }

    public Method[] getAllMethods(ModelClass modelClass) {
        Method[] result = this.getAllMethsInt(modelClass);
        return result;
    }

    public ModelRelationRole getOtherRole(ModelRelationRole thisRole) {
        ModelRelationRole[] allRoles = thisRole.getModelRelation().getModelRelationRoles();
        ModelRelationRole otherRole = null;
        int i = 0;
        while (i < allRoles.length) {
            if (!thisRole.getName().equals(allRoles[i].getName())) {
                otherRole = allRoles[i];
                break;
            }
            ++i;
        }
        return otherRole;
    }

    private ModelRelationRole[] getAllTargetRolesTo1Int(ModelClass modelClass) {
        ModelRelationRole[] myRoles = this.getTargetRolesTo1(modelClass);
        int size = myRoles.length;
        ModelClass[] superInterfaces = modelClass.getInterfaces();
        ModelRelationRole[][] superRoles = new ModelRelationRole[superInterfaces.length][];
        int i = 0;
        while (i < superInterfaces.length) {
            superRoles[i] = this.getAllTargetRolesTo1Int(superInterfaces[i]);
            size += superRoles[i].length;
            ++i;
        }
        ModelRelationRole[] result = new ModelRelationRole[size];
        int count = myRoles.length;
        System.arraycopy(myRoles, 0, result, 0, count);
        int i2 = 0;
        while (i2 < superRoles.length) {
            System.arraycopy(superRoles[i2], 0, result, count, superRoles[i2].length);
            count += superRoles[i2].length;
            ++i2;
        }
        return result;
    }

    private ModelRelationRole[] getAllTargetRolesToNInt(ModelClass modelClass) {
        ModelRelationRole[] myRoles = this.getTargetRolesToN(modelClass);
        int size = myRoles.length;
        ModelClass[] superInterfaces = modelClass.getInterfaces();
        ModelRelationRole[][] superRoles = new ModelRelationRole[superInterfaces.length][];
        int i = 0;
        while (i < superInterfaces.length) {
            superRoles[i] = this.getAllTargetRolesToNInt(superInterfaces[i]);
            size += superRoles[i].length;
            ++i;
        }
        ModelRelationRole[] result = new ModelRelationRole[size];
        int count = myRoles.length;
        System.arraycopy(myRoles, 0, result, 0, count);
        int i2 = 0;
        while (i2 < superRoles.length) {
            System.arraycopy(superRoles[i2], 0, result, count, superRoles[i2].length);
            count += superRoles[i2].length;
            ++i2;
        }
        return result;
    }

    private Method[] getAllMethsInt(ModelClass modelClass) {
        Method[] myMethods = modelClass.getMethods();
        int size = myMethods.length;
        ModelClass[] superInterfaces = modelClass.getInterfaces();
        Method[][] superMethods = new Method[superInterfaces.length][];
        int i = 0;
        while (i < superInterfaces.length) {
            superMethods[i] = this.getAllMethsInt(superInterfaces[i]);
            size += superMethods[i].length;
            ++i;
        }
        Method[] result = new Method[size];
        int count = myMethods.length;
        System.arraycopy(myMethods, 0, result, 0, count);
        int i2 = 0;
        while (i2 < superMethods.length) {
            System.arraycopy(superMethods[i2], 0, result, count, superMethods[i2].length);
            count += superMethods[i2].length;
            ++i2;
        }
        return result;
    }

    private Property[] getAllPropsInt(ModelClass modelClass) {
        Property[] myProperties = modelClass.getProperties();
        int size = myProperties.length;
        ModelClass[] superInterfaces = modelClass.getInterfaces();
        Property[][] superProperties = new Property[superInterfaces.length][];
        int i = 0;
        while (i < superInterfaces.length) {
            superProperties[i] = this.getAllPropsInt(superInterfaces[i]);
            size += superProperties[i].length;
            ++i;
        }
        Property[] result = new Property[size];
        int count = myProperties.length;
        System.arraycopy(myProperties, 0, result, 0, count);
        int i2 = 0;
        while (i2 < superProperties.length) {
            System.arraycopy(superProperties[i2], 0, result, count, superProperties[i2].length);
            count += superProperties[i2].length;
            ++i2;
        }
        return result;
    }

    public String getQualifiedModelClassName(ModelRelationRole role) {
        return role.getModelClass().getQualifiedName();
    }

    public String getQualifiedModelRelationName(ModelRelationRole role) {
        return role.getModelRelation().getName();
    }

    public boolean isMBean(ModelClass modelClass) {
        boolean result = true;
        ModelClassSetting classTypeSetting = modelClass.getSetting("jmx.model.class.type");
        if (classTypeSetting != null && !classTypeSetting.getValue().equals("mbean")) {
            result = false;
        }
        return result;
    }

    public boolean canBeChanged(ModelRelationRole role) {
        boolean result = false;
        ModelRelationRoleSetting roleSetting = role.getSetting("jmx.model.role.change");
        if (roleSetting != null && roleSetting.getValue().equals("true")) {
            result = true;
        }
        return result;
    }

    public boolean isReturnTypeCompositeData(Model model, Method method) {
        JavaNativeType nativeType;
        DevelopmentObject type = method.getReturnType();
        if (this.isJavaPrimitive(type)) {
            return false;
        }
        return type instanceof JavaNativeType && model.hasModelClass((nativeType = (JavaNativeType)type).getJavaPackage(), nativeType.getName());
    }

    public boolean isPropertyCompositeData(Model model, Property prop) {
        JavaNativeType nativeType;
        DevelopmentObject type = prop.getType();
        if (this.isJavaPrimitive(type)) {
            return false;
        }
        return type instanceof JavaNativeType && model.hasModelClass((nativeType = (JavaNativeType)type).getJavaPackage(), nativeType.getName());
    }

    public String getParameterTypeAsString(Model model, Parameter param) {
        DevelopmentObject type = param.getType();
        if (type instanceof JavaNativeType) {
            JavaNativeType nativeType = (JavaNativeType)type;
            String name = model.hasModelClass(nativeType.getJavaPackage(), nativeType.getName()) ? "javax.management.openmbean.CompositeData" : StringUtil.getQualifiedClassName(nativeType.getJavaPackage(), nativeType.getName());
            return this.convertToInternalClassName(nativeType.getArrayDimensions(), name);
        }
        return this.getQualifiedJavaClassName(type);
    }
}

